f.TotalWrap <- function (
				path_root.ch        = "/Users/danielemerico/Documents/Research_Works/Autism_CNV_Revolutions/",
				path_Rws_unit.ch    = "R_Works/R_ws/",
				path_FunEnr_unit.ch = "R_Works/R_functions/02_EnrTest/",
				GS.filename         = "core01_GS_Hs_GO_KEGG_React_PFAM_min5max700.RData",
				CNV.filename        = "core00_ASD_CNV_Conv.RData", 
				CNV_Limits.nv  = NULL,  
				Blacklist.eg   = "",
				Iter.n         = 2000
				)
				
# CNV.df = ASD_CNVs.df

	{
		
	# Notes: 
	# - make CNV key should be in the beginning
	# - the filtered CNV table should be output as well

	path_Rws.ch     <- paste (path_root.ch, path_Rws_unit.ch, sep = "")
	path_Fun_Enr.ch <- paste (path_root.ch, path_FunEnr_unit.ch, sep = "")
		
	cat ("\nBEGIN\n")

	cat ("\nLoad Data and Functions...\n")

	load (paste (path_Rws.ch, CNV.filename, sep = ""))
	load (paste (path_Rws.ch, GS.filename, sep = ""))

	setwd (path_Fun_Enr.ch)
	functions.ls <- as.list (setdiff (list.files (), "Wrap_Total_01.R"))
	lapply (functions.ls, source)

	# Rename variables from loaded ws
	GS2Genes.ls <- GS_Hs_GKNRP_eg_f.ls
	CNV.df      <- ASD_CNVs.df
	GS2Name.chv <- GS_Hs_GKNRP_ID2name.chv

	# Sample2Class.df <- Sample2Class.df
	# Sample2Stats.df <- Sample2Stats.df

	cat ("\nFiltering...\n")	
	CNV_f.df <- f.Filter_CNV2gene (
					CNV.df = CNV.df, 
					CNV_limits.nv = CNV_Limits.nv,
					blacklist.eg  = Blacklist.eg
					)

	cat ("\nMaking CNV Keys...\n")	
	CNV_f.df <- f.MakeCNV_key (CNV_f.df)
		
	cat ("\nSamples to Genes...\n")		
	Samples2Genes.ls <- 
		f.Comp_Sample2genes (CNV.df = CNV_f.df)

	cat ("\nSamples to Gene-sets...\n")		
	Sample2GS.tab <- f.Comp_Sample2GS (
					GS2genes.ls = GS2Genes.ls, 
					Sample2genes.ls = Samples2Genes.ls, 
					Sample2class.df = Sample2Class.df
					)

	cat ("\nFisher's Test for Gene-set Enrichment - FDR...\n")
	Enr_1.df <- f.FisherTestGS_FDR_Wrap (
					Sample2GS.tab   = Sample2GS.tab, 
					Sample2class.df = Sample2Class.df, 
					iter.n = Iter.n
					)					

	cat ("\nAdd Gene-set Size and Name\n")
	Enr_2.df <- f.AddGeneSize (
					GS2genes.ls = GS2Genes.ls, 
					Enr.df      = Enr_1.df
					)

	Enr_2.df <- f.Add_GSname (
					GS2name.chv = GS2Name.chv, 
					Enr.df       = Enr_2.df
					)

	cat ("\nComputing Gene Counts...\n")
	CNV_Gene.tab <- 
		f.CompGeneCounts (CNV.df = CNV_f.df)	

	cat ("\nAdding Support Genes...\n")
	Enr_3.df <- f.AddSupportGenes (
					GS_enr.df       = Enr_2.df, 
					Genes2class.tab = CNV_Gene.tab, 
					GS2genes.ls     = GS2Genes.ls
					)

	Enr_3.df <- f.Conv_SupportGenes_EG2sy (
					GS_enr.df      = Enr_3.df, 
					Conv_eg2sy.chv = Ann_eg2sy.chv
					)

	cat ("\nMaking Gene Tables...\n")
	GeneTable.ls <- f.MakeGeneTable (
					Enr.df         = Enr_3.df, 
					eg2sy.chv      = Ann_eg2sy.chv, 
					GeneCounts.tab = CNV_Gene.tab, 
					GS2genes.ls    = GS2Genes.ls, 
					CNV.df         = CNV_f.df
					)

	cat ("\nAdding Case Indexes and CNV Statistics...\n")
	Enr_4.df <- 
		f.AddCaseIndexes (Enr.df = Enr_3.df)
	
	Enr_4.df <- f.Add_CaseCNV_LengthStats (
					Enr.df = Enr_4.df, 
					CNV.df = CNV_f.df, 
					GeneTable.ls = GeneTable.ls
					)			

	cat ("\nAdding Sample Data...\n")
	Enr_5.df	<- f.AddSamples (
					Sample2GS.tab   = Sample2GS.tab, 
					Sample2class.df = Sample2Class.df, 
					GS_enr.df       = Enr_4.df
					)


	cat ("\nCalculating Sample Association Statistics...\n")
	SampleStats.df <- f.AddSampleStats (
					GS_enr.df = Enr_5.df, 
					Sample2class.df = Sample2Class.df, 
					Sample2stats.df = Sample2Stats.df 
					)				
						
	cat ("\nCalculating Sample CNV Global Statistics...\n")
	SampleCNV_Stats.df <- f.MakeSampleCNVstats (
					Enr.df = Enr_5.df,
					CNV.df = CNV_f.df
					)

	cat ("\nAdding CNV keys to Gene-sets...\n")
	GS_CNV.df <- f.AddCNV (
					Enr.df     = Enr_5.df,
					CNV.df     = CNV_f.df,
					GS2gene.ls = GS2Genes.ls
					)
				
	cat ("\nEND\n")
	Enr_final.df <- cbind (Enr_5.df, SampleCNV_Stats.df, SampleStats.df, GS_CNV.df)
				
	return (list (Enr = Enr_final.df, GeneCounts = CNV_Gene.tab, GeneTable = GeneTable.ls ))
	}


