f.MakeSampleCNVstats <- function (
							Enr.df, 
							CNV.df
							)
	{
	
	GS2sample_cs.ls <- strsplit (Enr.df$SamplesCase, split = ";")
	GS2sample_ct.ls <- strsplit (Enr.df$SamplesCtrl, split = ";")
	
	f.CNVstats_Unit <- function (input.samples)
	# Improve by first building sample-level summaries
	# - number
	# - log of total
	# - median of log
	# * use:
	#   CNV_selecta.df <- CNV.df$Length[CNV.df$SampleID %in% input.samples]
	#   CNV_selecta.ls <- unstack (CNV.df, Length ~ SampleID)
	#   and then generates the stats above per sample (corresp to slot ID)
	# and then gene-set level summaries
	# - Q1, median, Q3 of (number)
	# - Q1, median, Q3 of (log of total)
	# - Q1, median, Q3 of (median of log)
		{
		if (length (input.samples) < 1)
			{
			t_n_stats.nv <- 0
			t_l_stats.nv <- 0
			mdn_stats.nv <- 0
			}
		else
			{
			CNV_selecta.df <- CNV.df[CNV.df$SampleID %in% input.samples, c ("SampleID", "Length")]
			CNV_selecta.ls <- unstack (CNV_selecta.df, Length ~ SampleID)
			t_n.nv <- unlist (lapply (CNV_selecta.ls, length)) 
			t_l.nv <- log (unlist (lapply (CNV_selecta.ls, sum)))
			mdn.nv <- unlist (lapply (lapply (CNV_selecta.ls, log), median))
			probs.nv <- c (0.25, 0.5, 0.75)
			t_n_stats.nv <- quantile (x = t_n.nv, probs = probs.nv)
			t_l_stats.nv <- quantile (x = t_l.nv, probs = probs.nv) 
			mdn_stats.nv <- quantile (x = mdn.nv, probs = probs.nv)
			}
		return (c (t_n_stats.nv, t_l_stats.nv, mdn_stats.nv))
		}
		
	CNVstats_cs.df <- as.data.frame (t (as.data.frame (lapply (GS2sample_cs.ls, f.CNVstats_Unit))))
	CNVstats_ct.df <- as.data.frame (t (as.data.frame (lapply (GS2sample_ct.ls, f.CNVstats_Unit))))

	const.ch <-	paste (
				c (
					rep ("NumTot", 3), 
					rep ("LenTot", 3), 
					rep ("LenMdn", 3)
					), 
				rep (c ("_Q1", "_Md", "_Q3"), 3),
				sep = ""
				)

	colnames (CNVstats_cs.df) <- 
		paste (
			rep ("CNV_csS_", 9),
			const.ch, 
			sep = "") 
	colnames (CNVstats_ct.df) <- 
		paste (
			rep ("CNV_ctS_", 9),
			const.ch, 
			sep = "") 
	
	# Enr.df <- cbind (Enr.df, CNVstats_cs.df, CNVstats_ct.df)
	# return (Enr.df)

	output.df <- cbind (CNVstats_cs.df, CNVstats_ct.df)
	rownames (output.df) <- Enr.df$GS_ID

	return (output.df)
	}