f.MakeGeneTable <- function (Enr.df, eg2sy.chv, GeneCounts.tab, GS2genes.ls, CNV.df)

	{
	library (org.Hs.eg.db)
	
	# org.Hs.egGENENAME
	# org.Hs.egCHR
	# org.Hs.egCHRLOC
	# org.Hs.egCHRLOCEND
	
	f.ReductioAdUnum <- function (input.chv)
		{return (input.chv[1])}
	
	eg2sy.chv <- unlist (lapply (as.list (org.Hs.egSYMBOL), f.ReductioAdUnum))
	
	Ann_1.df <- data.frame (
				Eg      = names (eg2sy.chv),
				Symbol  = eg2sy.chv,
				Name    = unlist (lapply (as.list (org.Hs.egGENENAME),  f.ReductioAdUnum)),
				stringsAsFactors = F
				)
				
	Ann_2.df <- data.frame (
				Eg      = names (eg2sy.chv),
				Chr     = unlist (lapply (as.list (org.Hs.egCHR),       f.ReductioAdUnum)),
	            Coord_i = unlist (lapply (as.list (org.Hs.egCHRLOC),    f.ReductioAdUnum)),
				Coord_f = unlist (lapply (as.list (org.Hs.egCHRLOCEND), f.ReductioAdUnum)),
				stringsAsFactors = F
				)

	f.MakeGene2Key <- function (CNV.df)
		{
		CNV2genes.ls <- strsplit (CNV.df$Genes_eg, split = ";")
		names (CNV2genes.ls) <- CNV.df$Key
		CNV2genes.df <- stack (CNV2genes.ls)
		colnames (CNV2genes.df) <- c ("Gene", "Key")
		gene2CNV.ls <- unstack (CNV2genes.df, form = Key ~ Gene)
		
		return (gene2CNV.ls)		
		}
	
	CNV_cs.df <- CNV.df[CNV.df$Class == "case", ]
	CNV_ct.df <- CNV.df[CNV.df$Class == "control", ]
	gene2CNV_cs.ls <- f.MakeGene2Key (CNV.df = CNV_cs.df)
	gene2CNV_ct.ls <- f.MakeGene2Key (CNV.df = CNV_ct.df)

	f.GeneTable_Unit <- function (input.genes)
		{
		# only genes that bear at least 1 CNV
		input.genes <- intersect (input.genes, rownames (GeneCounts.tab))	
		GeneTable_1.df <- Ann_1.df[match (input.genes, Ann_1.df$Eg), ]
		GeneTable_2.df <- data.frame (
							CountCase = GeneCounts.tab[input.genes, "case"],
							CountCtrl = GeneCounts.tab[input.genes, "control"],
							stringsAsFactors = F
							)
		GeneTable_2.df$CountIndex <- (GeneTable_2.df$CountCase - GeneTable_2.df$CountCtrl) / GeneTable_2.df$CountCase
		GeneTable_3.df <- Ann_2.df[match (input.genes, Ann_2.df$Eg), ]
		
		GeneTable.df <- cbind (GeneTable_1.df, GeneTable_2.df, GeneTable_3.df)

		f.collapse <- function (input.chv)
			{return (paste (input.chv, collapse = ";"))}

		GeneTable.df$CNV_case <- unlist (lapply (gene2CNV_cs.ls[GeneTable.df$Eg], f.collapse))
		GeneTable.df$CNV_ctrl <- unlist (lapply (gene2CNV_ct.ls[GeneTable.df$Eg], f.collapse))
		
		supp.bnv <- as.numeric (GeneTable_2.df$CountCase > GeneTable_2.df$CountCtrl)
		
		GeneTable.df <- GeneTable.df[order (supp.bnv, GeneTable.df$CountCase, decreasing = T), ]
		
		return (GeneTable.df)
		}
	
	GeneTables.ls <- lapply (GS2genes.ls[Enr.df$GS_ID], f.GeneTable_Unit)
	names (GeneTables.ls) <- Enr.df$GS_ID
	
	return (GeneTables.ls)
	}