# FUNCTION TO GENERATE GENE COUNTS 
# FROM CNV DATA TABLE
# - using the unfiltered CNV table gives the counts for ALL
# - filtered CNV tables can be used for specific counts

f.CompGeneCounts <- function (CNV.df)

# Input description:
# - CNV.df (ASD_CNVs.df)
#   - Class 
#   - SampleID 
#   - Type 
#   - Genes_sy 
#   - Genes_eg

	{
	genes.ls  <- strsplit (x = CNV.df$Genes_eg, split = ";")
	gene_count.nv <- lapply (genes.ls, length)
	all.genes <- unique (unlist (genes.ls))

	names (genes.ls) <- c (1: length (genes.ls))
	temp.df <- stack (genes.ls[gene_count.nv > 0])

	# This weird patch is required as $ind 
	# is automatically set to factor
	temp.df$ind <- as.numeric (as.character (temp.df$ind))

	class2gene.df <- 
		data.frame (
			Class = CNV.df$Class[temp.df$ind],
			EG    = as.character (temp.df$values),
			stringsAsFactors = F
		)

	gene2class.tab <- t (table (class2gene.df))

	return (gene2class.tab)

	}
