# THIS FUNCTION REMOVES MAPPED GENES
# THAT DO NOT CONFORM WITH THE INPUT CNV TYPE
# A modified version is defined to select only CNV

f.Filter_CNV2gene <- function (CNV.df, CNV_limits.nv = NULL, blacklist.eg = "")

# Input description:
# - CNV_type.ch
#   - "ALL" --> c (0, 1, 3)
#   - "DEL" --> c (0, 1), 
#   - "DUP" --> 3
# - CNV.df (ASD_CNVs.df)
#   - Class 
#   - SampleID 
#   - Type 
#   - Genes_sy 
#   - Genes_eg

	{
	if (is.null (CNV_limits.nv))
		{
		CNV_limits.nv <- c (+Inf, +Inf)
		names (CNV_limits.nv) <- c ("DEL", "DUP")
		}

	# Symbol genes will not be filtered

	CNV_types.nv <- c (0, 1, 3)
	names (CNV_types.nv) <- c ("DEL", "DEL", "DUP")

	CNV2genes.ls <- strsplit (CNV.df$Genes_eg, split = ";")
	length.nv <- unlist (lapply (CNV2genes.ls, length))

	CNV.df$Genes_eg[
		CNV.df$Type %in% CNV_types.nv[names (CNV_types.nv) == "DEL"] & 
		length.nv > CNV_limits.nv["DEL"]
		] <- ""
	CNV.df$Genes_eg[
		CNV.df$Type %in% CNV_types.nv[names (CNV_types.nv) == "DUP"] & 
		length.nv > CNV_limits.nv["DUP"]
		] <- ""

	f.Find_blacklisted_Unit <- function (x.eg)
		{
		return (sum (blacklist.eg %in% x.eg) > 0)
		}
		
	CNV.df$Genes_eg[
		intersect (
			which (length.nv <= 2),
			which (unlist (lapply (CNV2genes.ls, f.Find_blacklisted_Unit)))
			)
		] <- ""
	
	return (CNV.df)
	
	}
	
	


