f.AddSupportGenes <- function (GS_enr.df, Genes2class.tab, GS2genes.ls)

	{

	f.AddSupportGenes_Unit <- function (input.genes)
		{
		support.genes <- intersect (
			rownames (Genes2class.tab)[Genes2class.tab[, "case"] > Genes2class.tab[, "control"]],
			input.genes
			)
		return (support.genes)
		}
	f.Length_Unit <- function (input.genes)
		{return (length (input.genes))}
	f.Collapse_Unit <- function (input.genes) 
		{return (paste (input.genes, collapse = ";"))}
	
	support_genes.ls  <- lapply (GS2genes.ls[GS_enr.df$GS_ID], f.AddSupportGenes_Unit)
	support_length.nv <- unlist (lapply (support_genes.ls, f.Length_Unit))
	support_ratio.nv  <- support_length.nv / GS_enr.df$GS_size
	support_genes.chv <- unlist (lapply (support_genes.ls, f.Collapse_Unit))

	GS_enr.df$SupportSize  <- support_length.nv
	GS_enr.df$SupportRatio <- support_ratio.nv 
	GS_enr.df$SupportGenes <- support_genes.chv

	return (GS_enr.df)

	}
	