f.AddSamples <- function (Sample2GS.tab, Sample2class.df, GS_enr.df)

	{

	# Retrieves samples with at least one mutation
	# - output: collapsed character from character array

	case.samples <- Sample2class.df$SampleID[Sample2class.df$Class == "case"]
	ctrl.samples <- Sample2class.df$SampleID[Sample2class.df$Class == "control"]

	Sample2GS_case.tab <- Sample2GS.tab[intersect (rownames (Sample2GS.tab), case.samples), ]
	Sample2GS_ctrl.tab <- Sample2GS.tab[intersect (rownames (Sample2GS.tab), ctrl.samples), ]

	f.GS2samples_Unit <- function (counts.nv)
		{
		samples.chv <- names (counts.nv)[counts.nv > 0]
		output.ch   <- paste (samples.chv, collapse = ";")
		return (output.ch)
		}

	GS_enr.df$SamplesCase <- apply (Sample2GS_case.tab[, GS_enr.df$GS_ID], 2, f.GS2samples_Unit)
	GS_enr.df$SamplesCtrl <- apply (Sample2GS_ctrl.tab[, GS_enr.df$GS_ID], 2, f.GS2samples_Unit)
	
	return (GS_enr.df)
	}

