f.AddCNV <- function (
				Enr.df,
				CNV.df,
				GS2gene.ls
				)
	{

	CNV2genes.ls <- strsplit (CNV.df$Genes_eg, split = ";")
	names (CNV2genes.ls) <- CNV.df$Key
	CNV2genes.df <- stack (CNV2genes.ls)
	colnames (CNV2genes.df) <- c ("Gene", "Key")
	
	f.AddCNV_Unit <- function (input.genes)
		{
		return (CNV2genes.df$Key[CNV2genes.df$Gene %in% input.genes])
		}
	f.SubsetKey_Case_Unit <- function (input.keys)
		{
		output.chv <- intersect (CNV.df$Key[CNV.df$Class == "case"], input.keys)
		return (paste (output.chv, collapse = ";"))
		}
	f.SubsetKey_Ctrl_Unit <- function (input.keys)
		{
		output.chv <- intersect (CNV.df$Key[CNV.df$Class == "control"], input.keys)
		return (paste (output.chv, collapse = ";"))
		}
	
	GS2key.ls <- lapply (GS2gene.ls[Enr.df$GS_ID], f.AddCNV_Unit)

	Enr.df$GS_CNV_case <- unlist (lapply (GS2key.ls, f.SubsetKey_Case_Unit))
	Enr.df$GS_CNV_ctrl <- unlist (lapply (GS2key.ls, f.SubsetKey_Ctrl_Unit))

	# return (Enr.df)	
	
	output.df <- Enr.df[, c ("GS_CNV_case", "GS_CNV_ctrl")]
	rownames (output.df) <- output.df$GS_ID
	
	return (output.df)
	}