/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud.test;

import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CloudWordInfo;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class CloudParametersUnitTest
extends TestCase {
    String cloudName = "CloudName";
    SemanticSummaryParameters parentParams;
    CloudParameters cloudParams;
    String charString = Character.toString('\u001f');

    @Before
    public void setUp() throws Exception {
        this.parentParams = new SemanticSummaryParameters();
        ArrayList<CyNode> allNodes = new ArrayList<CyNode>();
        CyNode node1 = Cytoscape.getCyNode((String)"Node onenode", (boolean)true);
        CyNode node2 = Cytoscape.getCyNode((String)"Node twonode", (boolean)true);
        CyNode node3 = Cytoscape.getCyNode((String)"ONENODE", (boolean)true);
        CyNode node4 = Cytoscape.getCyNode((String)"Double double", (boolean)true);
        CyNode punctNode1 = Cytoscape.getCyNode((String)"Node with punctuation.", (boolean)true);
        CyNode punctNode2 = Cytoscape.getCyNode((String)"Node with non-stripped punctuation", (boolean)true);
        allNodes.add(node1);
        allNodes.add(node2);
        allNodes.add(node3);
        allNodes.add(node4);
        allNodes.add(punctNode1);
        allNodes.add(punctNode2);
        this.cloudParams = new CloudParameters();
        this.cloudParams.setCloudName(this.cloudName);
        this.cloudParams.setNetworkParams(this.parentParams);
        HashSet<CyNode> selNodes = new HashSet<CyNode>();
        CyNode node5 = Cytoscape.getCyNode((String)"Node onenode", (boolean)true);
        CyNode node6 = Cytoscape.getCyNode((String)"Node twonode", (boolean)true);
        CyNode node7 = Cytoscape.getCyNode((String)"ONENODE", (boolean)true);
        CyNode node8 = Cytoscape.getCyNode((String)"Double double", (boolean)true);
        CyNode node9 = Cytoscape.getCyNode((String)"Reactome_node to strip lots from.", (boolean)true);
        CyNode punctNode3 = Cytoscape.getCyNode((String)"Node with punctuation.", (boolean)true);
        CyNode punctNode4 = Cytoscape.getCyNode((String)"Node with non-stripped punctuation", (boolean)true);
        allNodes.add(node5);
        allNodes.add(node6);
        allNodes.add(node7);
        allNodes.add(node8);
        allNodes.add(node9);
        allNodes.add(punctNode3);
        allNodes.add(punctNode4);
        selNodes.add(node5);
        selNodes.add(node6);
        selNodes.add(node7);
        selNodes.add(node8);
        selNodes.add(node9);
        selNodes.add(punctNode3);
        selNodes.add(punctNode4);
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator iter = allNodes.iterator();
        while (iter.hasNext()) {
            nodeNames.add(iter.next().toString());
        }
        this.parentParams.setNetworkNodes(nodeNames);
        ArrayList<String> selNodeNames = new ArrayList<String>();
        Iterator iter2 = selNodes.iterator();
        while (iter2.hasNext()) {
            selNodeNames.add(iter2.next().toString());
        }
        this.cloudParams.setSelectedNodes(selNodeNames);
        this.cloudParams.setSelectedNumNodes(7);
        this.cloudParams.setNetworkNumNodes(13);
        this.cloudParams.setNetWeightFactor(1.0);
        this.cloudParams.setDisplayStyle("No Clustering");
        this.parentParams.addCloud(this.cloudName, this.cloudParams);
    }

    @Test
    public void testInitializeNetworkCounts() {
        CloudParametersUnitTest.assertFalse(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
        this.cloudParams.initializeNetworkCounts();
        HashMap<String, Integer> counts = this.cloudParams.getNetworkCounts();
        CloudParametersUnitTest.assertEquals(counts.get("node"), new Integer(9));
        CloudParametersUnitTest.assertEquals(counts.get("onenode"), new Integer(4));
        CloudParametersUnitTest.assertEquals(counts.get("twonode"), new Integer(2));
        CloudParametersUnitTest.assertEquals(counts.get("double"), new Integer(2));
        CloudParametersUnitTest.assertEquals(counts.get("punctuation"), new Integer(4));
        CloudParametersUnitTest.assertEquals(counts.get("non-stripped"), new Integer(2));
        CloudParametersUnitTest.assertEquals(counts.get("strip"), new Integer(1));
        CloudParametersUnitTest.assertEquals(counts.get("with"), null);
        CloudParametersUnitTest.assertEquals(counts.get("reactome"), null);
        HashMap<String, Integer> pairCounts = this.cloudParams.getNetworkPairCounts();
        CloudParametersUnitTest.assertEquals(pairCounts.get("node" + this.charString + "onenode"), new Integer(2));
        CloudParametersUnitTest.assertEquals(pairCounts.get("strip" + this.charString + "lots"), new Integer(1));
        HashMap<String, List<String>> mapping = this.cloudParams.getStringNodeMapping();
        List<String> nodeList = mapping.get("strip");
        for (String curNodeName : nodeList) {
            CyNode curNode = Cytoscape.getCyNode((String)curNodeName);
            CloudParametersUnitTest.assertEquals(curNode.toString(), "Reactome_node to strip lots from.");
        }
        int count = 0;
        nodeList = mapping.get("twonode");
        for (String curNodeName : nodeList) {
            CyNode curNode = Cytoscape.getCyNode((String)curNodeName);
            CloudParametersUnitTest.assertEquals(curNode.toString(), "Node twonode");
            ++count;
        }
        CloudParametersUnitTest.assertEquals(count, 2);
        CloudParametersUnitTest.assertTrue(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
    }

    @Test
    public void testUpdateSelectedCounts() {
        CloudParametersUnitTest.assertFalse(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
        this.cloudParams.updateSelectedCounts();
        HashMap<String, Integer> counts = this.cloudParams.getSelectedCounts();
        CloudParametersUnitTest.assertEquals(counts.get("node"), new Integer(5));
        CloudParametersUnitTest.assertEquals(counts.get("onenode"), new Integer(2));
        CloudParametersUnitTest.assertEquals(counts.get("twonode"), new Integer(1));
        CloudParametersUnitTest.assertEquals(counts.get("double"), new Integer(1));
        CloudParametersUnitTest.assertEquals(counts.get("punctuation"), new Integer(2));
        CloudParametersUnitTest.assertEquals(counts.get("non-stripped"), new Integer(1));
        CloudParametersUnitTest.assertEquals(counts.get("strip"), new Integer(1));
        CloudParametersUnitTest.assertEquals(counts.get("with"), null);
        CloudParametersUnitTest.assertEquals(counts.get("reactome"), null);
        HashMap<String, Integer> pairCounts = this.cloudParams.getSelectedPairCounts();
        CloudParametersUnitTest.assertEquals(pairCounts.get("node" + this.charString + "onenode"), new Integer(1));
        CloudParametersUnitTest.assertEquals(pairCounts.get("strip" + this.charString + "lots"), new Integer(1));
        CloudParametersUnitTest.assertTrue(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertTrue(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
    }

    @Test
    public void testUpdateRatios() {
        CloudParametersUnitTest.assertFalse(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
        this.cloudParams.updateRatios();
        HashMap<String, Double> ratios = this.cloudParams.getRatios();
        CloudParametersUnitTest.assertEquals(ratios.get("node"), new Double(1.0317460317460319));
        CloudParametersUnitTest.assertEquals(ratios.get("onenode"), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertEquals(ratios.get("twonode"), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertEquals(ratios.get("double"), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertEquals(ratios.get("punctuation"), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertEquals(ratios.get("non-stripped"), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertEquals(ratios.get("strip"), new Double(1.8571428571428572));
        CloudParametersUnitTest.assertEquals(ratios.get("with"), null);
        CloudParametersUnitTest.assertEquals(ratios.get("reactome"), null);
        HashMap<String, Double> pairRatios = this.cloudParams.getPairRatios();
        CloudParametersUnitTest.assertEquals(pairRatios.get("node" + this.charString + "onenode"), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertEquals(this.cloudParams.getMaxRatio(), new Double(1.8571428571428572));
        CloudParametersUnitTest.assertEquals(this.cloudParams.getMinRatio(), new Double(0.9285714285714286));
        CloudParametersUnitTest.assertTrue(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertTrue(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertTrue(this.cloudParams.getRatiosInitialized());
    }

    @Test
    public void testCalculateFontSizes() {
        CloudParametersUnitTest.assertFalse(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
        this.cloudParams.setNetWeightFactor(0.0);
        this.cloudParams.calculateFontSizes();
        ArrayList<CloudWordInfo> cloudWords = this.cloudParams.getCloudWordInfoList();
        CloudParametersUnitTest.assertEquals(cloudWords.get(0).getFontSize(), new Integer(this.parentParams.getMaxFont()));
        CloudParametersUnitTest.assertEquals(cloudWords.get(cloudWords.size() - 1).getFontSize(), new Integer(this.parentParams.getMinFont()));
        CloudParametersUnitTest.assertTrue(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertTrue(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertTrue(this.cloudParams.getRatiosInitialized());
        this.cloudParams.setNetWeightFactor(1.0);
        CloudParametersUnitTest.assertTrue(this.cloudParams.getCountInitialized());
        CloudParametersUnitTest.assertTrue(this.cloudParams.getSelInitialized());
        CloudParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
        this.cloudParams.calculateFontSizes();
        cloudWords = this.cloudParams.getCloudWordInfoList();
        CloudParametersUnitTest.assertEquals(cloudWords.get(cloudWords.size() - 1).getFontSize(), new Integer(this.parentParams.getMinFont()));
    }
}

