/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudDisplayPanel;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryInputPanel;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelListener;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class SemanticSummaryPluginAction
extends CytoscapeAction {
    private static final long serialVersionUID = -5407980202304156167L;

    public SemanticSummaryPluginAction() {
        super("Settings");
    }

    public void actionPerformed(ActionEvent ae) {
        this.doRealAction();
    }

    public void doRealAction() {
        CloudParameters nullCloud = SemanticSummaryManager.getInstance().getNullCloudParameters();
        if (nullCloud == null) {
            SemanticSummaryManager.getInstance().setupNullCloudParams();
        }
        boolean loaded = this.loadInputPanel();
        this.loadCloudPanel();
        if (!loaded) {
            SemanticSummaryManager.getInstance().setupCurrentNetwork();
        }
    }

    public boolean loadInputPanel() {
        boolean loaded = false;
        int index = 0;
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        SemanticSummaryInputPanel inputWindow = SemanticSummaryManager.getInstance().getInputWindow();
        if (inputWindow == null) {
            inputWindow = new SemanticSummaryInputPanel();
            SemanticSummaryManager.getInstance().setInputWindow(inputWindow);
            cytoPanel.add("WordCloud", (Component)inputWindow);
            index = cytoPanel.indexOfComponent((Component)inputWindow);
            cytoPanel.setSelectedIndex(index);
            cytoPanel.addCytoPanelListener((CytoPanelListener)new InputPanelSelectListener(index));
        } else {
            cytoPanel.add("WordCloud", (Component)inputWindow);
            index = cytoPanel.indexOfComponent((Component)inputWindow);
            cytoPanel.setSelectedIndex(index);
            loaded = true;
        }
        return loaded;
    }

    public void loadCloudPanel() {
        int index = 0;
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        CloudDisplayPanel cloudWindow = SemanticSummaryManager.getInstance().getCloudWindow();
        if (cloudWindow == null) {
            cloudWindow = new CloudDisplayPanel();
            SemanticSummaryManager.getInstance().setCloudDisplayWindow(cloudWindow);
            cytoPanel.add("WordCloud Display", (Component)cloudWindow);
            index = cytoPanel.indexOfComponent((Component)cloudWindow);
            cytoPanel.setSelectedIndex(index);
        } else {
            cytoPanel.add("WordCloud Display", (Component)cloudWindow);
            index = cytoPanel.indexOfComponent((Component)cloudWindow);
            cytoPanel.setSelectedIndex(index);
        }
    }

    public class InputPanelSelectListener
    implements CytoPanelListener {
        public InputPanelSelectListener(int index) {
        }

        public void onComponentSelected(int ComponentIndex) {
            SemanticSummaryManager.getInstance().refreshCurrentNetworkList();
        }

        public void onComponentAdded(int arg0) {
        }

        public void onComponentRemoved(int arg0) {
        }

        public void onStateChange(CytoPanelState arg0) {
        }
    }
}

