/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudDisplayPanel;
import cytoscape.csplugins.wordcloud.CloudListSelectionHandler;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryInputPanel;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.data.attr.MultiHashMapListener;
import giny.model.Node;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JList;
import javax.swing.ListSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSummaryManager
implements PropertyChangeListener,
MultiHashMapListener {
    private static SemanticSummaryManager manager = null;
    private HashMap<String, SemanticSummaryParameters> cyNetworkList = new HashMap();
    private SemanticSummaryInputPanel inputWindow;
    private CloudDisplayPanel cloudWindow;
    private SemanticSummaryParameters curNetwork;
    private CloudParameters curCloud;
    private SemanticSummaryParameters nullSemanticSummary = new SemanticSummaryParameters();
    private CloudParameters nullCloudParameters;

    private SemanticSummaryManager() {
        this.nullSemanticSummary.setNetworkName("No Network Loaded");
        this.nullCloudParameters = new CloudParameters();
        this.nullCloudParameters.setCloudName("Null Cloud");
        this.nullCloudParameters.setNetworkParams(this.nullSemanticSummary);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getDesktop().getNetworkViewManager().getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getNodeAttributes().getMultiHashMap().addDataListener((MultiHashMapListener)this);
        this.curNetwork = this.nullSemanticSummary;
        this.curCloud = this.nullCloudParameters;
    }

    public static SemanticSummaryManager getInstance() {
        if (manager == null) {
            manager = new SemanticSummaryManager();
        }
        return manager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED)) {
            this.networkDestroyed((String)event.getNewValue());
        } else if (event.getPropertyName().equals(Cytoscape.NETWORK_CREATED)) {
            this.setupCurrentNetwork();
        } else if (event.getPropertyName().equals("NETWORK_VIEW_DESTROYED")) {
            this.setupCurrentNetwork();
        } else if (event.getPropertyName().equals("NETWORK_VIEW_CREATED")) {
            this.setupCurrentNetwork();
        } else if (event.getPropertyName().equals("NETWORK_VIEW_FOCUSED")) {
            this.setupCurrentNetwork();
        } else if (event.getPropertyName().equals("NETWORK_TITLE_MODIFIED")) {
            CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
            String networkID = cyNetwork.getIdentifier();
            if (this.isSemanticSummary(networkID)) {
                SemanticSummaryParameters currentParams = this.getParameters(networkID);
                currentParams.setNetworkName(cyNetwork.getTitle());
                SemanticSummaryManager.getInstance().getInputWindow().getNetworkLabel().setText(currentParams.getNetworkName());
            }
        } else if (event.getPropertyName().equals(Cytoscape.ATTRIBUTES_CHANGED)) {
            this.inputWindow.refreshAttributeCMB();
        } else if (event.getPropertyName().equals("NETWORK_MODIFIED")) {
            this.networkModified();
        }
    }

    private void networkDestroyed(String networkID) {
        if (this.isSemanticSummary(networkID)) {
            this.cyNetworkList.remove(networkID);
        }
    }

    private void networkModified() {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        String networkID = network.getIdentifier();
        if (this.isSemanticSummary(networkID)) {
            SemanticSummaryParameters params = this.getParameters(networkID);
            params.updateParameters(network);
        }
    }

    public void registerNetwork(CyNetwork cyNetwork, SemanticSummaryParameters params) {
        this.cyNetworkList.put(cyNetwork.getIdentifier(), params);
    }

    public boolean isSemanticSummary(String networkID) {
        return this.cyNetworkList.containsKey(networkID);
    }

    public void setupCurrentNetwork() {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        String networkID = network.getIdentifier();
        if (network.equals(Cytoscape.getNullNetwork()) || network == null) {
            this.curNetwork = this.nullSemanticSummary;
            this.curCloud = this.nullCloudParameters;
        } else if (this.isSemanticSummary(networkID)) {
            this.curNetwork = this.getParameters(networkID);
        } else {
            SemanticSummaryParameters params = new SemanticSummaryParameters();
            params.updateParameters(network);
            SemanticSummaryManager.getInstance().registerNetwork(network, params);
            this.curNetwork = params;
        }
        this.getInputWindow().setNetworkList(this.curNetwork);
        this.getCloudWindow().clearCloud();
        this.getInputWindow().setUserDefaults();
        this.getInputWindow().refreshAttributeCMB();
        this.getInputWindow().refreshNetworkSettings();
        this.getInputWindow().loadCurrentCloud(this.curCloud);
    }

    public void refreshCurrentNetworkList() {
        CyNetwork network = Cytoscape.getCurrentNetwork();
        String networkID = network.getIdentifier();
        String newNetworkName = network.getTitle();
        String oldNetworkName = this.curNetwork.getNetworkName();
        JList cloudList = this.getInputWindow().getCloudList();
        Object selected = cloudList.getSelectedValue();
        String CloudName = this.curCloud.getCloudName();
        if (network.equals(Cytoscape.getNullNetwork()) || network == null) {
            this.curNetwork = this.nullSemanticSummary;
            this.curCloud = this.nullCloudParameters;
        } else if (this.isSemanticSummary(networkID)) {
            this.curNetwork = this.getParameters(networkID);
        } else {
            SemanticSummaryParameters params = new SemanticSummaryParameters();
            params.updateParameters(network);
            SemanticSummaryManager.getInstance().registerNetwork(network, params);
            this.curNetwork = params;
        }
        this.getInputWindow().setNetworkList(this.curNetwork);
        if (newNetworkName.equals(oldNetworkName) && selected != null) {
            ListSelectionModel listSelectionModel = cloudList.getSelectionModel();
            CloudListSelectionHandler handler = this.getInputWindow().getCloudListSelectionHandler();
            listSelectionModel.removeListSelectionListener(handler);
            String selectedValue = (String)selected;
            this.getInputWindow().getCloudList().setSelectedValue(selectedValue, true);
            listSelectionModel.addListSelectionListener(handler);
            if (this.curNetwork.containsCloud(CloudName)) {
                this.curCloud = this.curNetwork.getCloud(CloudName);
            }
        } else if (!newNetworkName.equals(oldNetworkName)) {
            this.getInputWindow().setUserDefaults();
            this.getInputWindow().refreshAttributeCMB();
            this.getCloudWindow().clearCloud();
        }
    }

    public SemanticSummaryParameters getParameters(String name) {
        if (this.cyNetworkList.containsKey(name)) {
            return this.cyNetworkList.get(name);
        }
        return null;
    }

    public void setupNullCloudParams() {
        this.nullCloudParameters = new CloudParameters();
        this.nullCloudParameters.setCloudName("Null Cloud");
        this.curCloud = this.nullCloudParameters;
    }

    public HashMap<String, SemanticSummaryParameters> getCyNetworkList() {
        return this.cyNetworkList;
    }

    public SemanticSummaryInputPanel getInputWindow() {
        return this.inputWindow;
    }

    public void setInputWindow(SemanticSummaryInputPanel inputWindow) {
        this.inputWindow = inputWindow;
    }

    public CloudDisplayPanel getCloudWindow() {
        return this.cloudWindow;
    }

    public void setCloudDisplayWindow(CloudDisplayPanel cloudWindow) {
        this.cloudWindow = cloudWindow;
    }

    public SemanticSummaryParameters getCurNetwork() {
        return this.curNetwork;
    }

    public void setCurNetwork(SemanticSummaryParameters params) {
        this.curNetwork = params;
    }

    public CloudParameters getCurCloud() {
        return this.curCloud;
    }

    public void setCurCloud(CloudParameters params) {
        this.curCloud = params;
    }

    public SemanticSummaryParameters getNullSemanticSummary() {
        return this.nullSemanticSummary;
    }

    public CloudParameters getNullCloudParameters() {
        return this.nullCloudParameters;
    }

    public void allAttributeValuesRemoved(String objectKey, String attributeName) {
    }

    public void attributeValueAssigned(String objectKey, String attributeName, Object[] keyIntoValue, Object oldAttributeValue, Object newAttributeValue) {
        CyNode curNode = Cytoscape.getCyNode((String)objectKey, (boolean)false);
        if (curNode != null) {
            HashMap<String, SemanticSummaryParameters> networks = SemanticSummaryManager.getInstance().getCyNetworkList();
            Set<String> names = networks.keySet();
            for (String curNetwork : names) {
                SemanticSummaryParameters params = networks.get(curNetwork);
                String networkName = params.getNetworkName();
                CyNetwork cyNetwork = Cytoscape.getNetwork((String)networkName);
                if (!cyNetwork.containsNode((Node)curNode)) continue;
                params.networkChanged();
            }
        }
    }

    public void attributeValueRemoved(String objectKey, String attributeName, Object[] keyIntoValue, Object attributeValue) {
    }
}

