/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class ModifiedClusterFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = 6950793266604882517L;

    public ModifiedClusterFlowLayout() {
    }

    public ModifiedClusterFlowLayout(int align) {
        super(align);
    }

    public ModifiedClusterFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.computeMinSize(target);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.computeSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            int reqdWidth = 0;
            int maxwidth = this.getMaxWidth(target);
            if ((maxwidth -= 2 * hgap) == 0) {
                maxwidth = Integer.MAX_VALUE - insets.left - insets.right;
            }
            int n = target.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowHeight = 0;
            for (int i = 0; i < n; ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += hgap;
                    }
                    x += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                } else {
                    x = d.width;
                    y += vgap + rowHeight;
                    rowHeight = d.height;
                }
                reqdWidth = Math.max(reqdWidth, x);
            }
            y += rowHeight;
            y += insets.bottom;
            return new Dimension(reqdWidth + insets.left + insets.right, y += vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeMinSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int minx = Integer.MAX_VALUE;
            int miny = Integer.MIN_VALUE;
            boolean found_one = false;
            int n = target.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                found_one = true;
                Dimension d = c.getPreferredSize();
                minx = Math.min(minx, d.width);
                miny = Math.min(miny, d.height);
            }
            if (found_one) {
                return new Dimension(minx, miny);
            }
            return new Dimension(0, 0);
        }
    }

    private int getMaxWidth(Container target) {
        int maxWidth = 0;
        int n = target.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = target.getComponent(i);
            if (!c.isVisible()) continue;
            int curWidth = c.getPreferredSize().width;
            maxWidth = Math.max(curWidth, maxWidth);
        }
        return maxWidth;
    }
}

