/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryPluginAction;
import cytoscape.view.CyNetworkView;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudWordInfo
implements Comparable<CloudWordInfo> {
    private String word;
    private Integer fontSize;
    private CloudParameters params;
    private Color textColor;
    private Integer cluster;
    private Integer wordNum;
    private static final String FIRSTDELIMITER = "TabbedEquivalent";
    private static final String SECONDDELIMITER = "NewLineEquivalent";

    public CloudWordInfo() {
        this.fontSize = 0;
        this.textColor = Color.BLACK;
        this.cluster = 0;
        this.wordNum = 0;
    }

    public CloudWordInfo(String aWord, Integer size) {
        this.word = aWord;
        this.fontSize = size;
        this.textColor = Color.BLACK;
        this.cluster = 0;
        this.wordNum = 0;
    }

    public CloudWordInfo(String propFile) {
        this();
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split(SECONDDELIMITER);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split(FIRSTDELIMITER);
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.word = (String)props.get("Word");
        this.fontSize = new Integer((String)props.get("FontSize"));
        this.cluster = new Integer((String)props.get("Cluster"));
        this.wordNum = new Integer((String)props.get("WordNum"));
        this.textColor = new Color(new Integer((String)props.get("TextColor")), true);
    }

    @Override
    public int compareTo(CloudWordInfo c) {
        Integer first = this.getFontSize();
        Integer second = c.getFontSize();
        int result = second.compareTo(first);
        if (result == 0 && (result = (first = this.getCluster()).compareTo(second = c.getCluster())) == 0 && (result = (first = this.getWordNumber()).compareTo(second = c.getWordNumber())) == 0) {
            String firstString = this.getWord();
            String secondString = c.getWord();
            result = firstString.compareTo(secondString);
        }
        return result;
    }

    public JLabel createCloudLabel() {
        JLabel label = new JLabel(this.getWord());
        label.setFont(new Font("sansserif", 1, this.getFontSize()));
        label.setForeground(this.textColor);
        label.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                String word = clickedLabel.getText();
                CloudParameters cloudParams = SemanticSummaryManager.getInstance().getCurCloud();
                List<String> nodeNames = cloudParams.getStringNodeMapping().get(word);
                ArrayList<CyNode> nodes = new ArrayList<CyNode>();
                for (String curNodeName : nodeNames) {
                    CyNode curNode = Cytoscape.getCyNode((String)curNodeName);
                    nodes.add(curNode);
                }
                CyNetwork network = Cytoscape.getCurrentNetwork();
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                if (view.getNetwork().equals(network)) {
                    network.unselectAllNodes();
                    network.unselectAllEdges();
                    network.setSelectedNodeState(nodes, true);
                    view.redrawGraph(false, true);
                    SemanticSummaryPluginAction init = new SemanticSummaryPluginAction();
                    init.loadCloudPanel();
                    init.loadInputPanel();
                }
            }

            public void mouseEntered(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                CyNetwork network = Cytoscape.getCurrentNetwork();
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                if (view.getNetwork().equals(network)) {
                    clickedLabel.setForeground(new Color(0, 200, 255));
                    clickedLabel.repaint();
                }
            }

            public void mouseExited(MouseEvent me) {
                JLabel clickedLabel = (JLabel)me.getComponent();
                if (!Cytoscape.getCurrentNetworkView().equals(Cytoscape.getNullNetworkView())) {
                    clickedLabel.setForeground(CloudWordInfo.this.textColor);
                    clickedLabel.repaint();
                }
            }
        });
        return label;
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("WordTabbedEquivalent" + this.word + SECONDDELIMITER);
        paramVariables.append("FontSizeTabbedEquivalent" + this.fontSize + SECONDDELIMITER);
        paramVariables.append("ClusterTabbedEquivalent" + this.cluster + SECONDDELIMITER);
        paramVariables.append("WordNumTabbedEquivalent" + this.wordNum + SECONDDELIMITER);
        paramVariables.append("TextColorTabbedEquivalent" + this.textColor.getRGB() + SECONDDELIMITER);
        return paramVariables.toString();
    }

    public void setWord(String aWord) {
        this.word = aWord;
    }

    public String getWord() {
        return this.word;
    }

    public void setFontSize(Integer size) {
        this.fontSize = size;
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setCloudParameters(CloudParameters curParams) {
        this.params = curParams;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color col) {
        this.textColor = col;
    }

    public Integer getCluster() {
        return this.cluster;
    }

    public void setCluster(Integer clusterNum) {
        this.cluster = clusterNum;
    }

    public Integer getWordNumber() {
        return this.wordNum;
    }

    public void setWordNumber(Integer num) {
        this.wordNum = num;
    }
}

