/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryInputPanel;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryPluginAction;
import cytoscape.view.CyNetworkView;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CloudListSelectionHandler
implements ListSelectionListener {
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.getValueIsAdjusting()) {
            return;
        }
        int index = lsm.getMinSelectionIndex();
        if (lsm.isSelectedIndex(index)) {
            SemanticSummaryInputPanel inputPanel = SemanticSummaryManager.getInstance().getInputWindow();
            String cloudName = (String)inputPanel.getListValues().elementAt(index);
            SemanticSummaryParameters params = SemanticSummaryManager.getInstance().getCurNetwork();
            if (!params.containsCloud(cloudName)) {
                String message = "Warning - Cloud no longer exists.";
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message);
                return;
            }
            CloudParameters cloudParams = params.getCloud(cloudName);
            inputPanel.loadCurrentCloud(cloudParams);
            SemanticSummaryManager.getInstance().getCloudWindow().updateCloudDisplay(cloudParams);
            if (!Cytoscape.getCurrentNetworkView().equals(Cytoscape.getNullNetworkView())) {
                List<String> selNodeNames = cloudParams.getSelectedNodes();
                HashSet<CyNode> selNodes = new HashSet<CyNode>();
                for (int i = 0; i < selNodeNames.size(); ++i) {
                    String curNodeID = selNodeNames.get(i);
                    CyNode curNode = Cytoscape.getCyNode((String)curNodeID);
                    selNodes.add(curNode);
                }
                CyNetwork network = Cytoscape.getCurrentNetwork();
                network.unselectAllNodes();
                network.unselectAllEdges();
                network.setSelectedNodeState(selNodes, true);
                CyNetworkView view = Cytoscape.getCurrentNetworkView();
                view.redrawGraph(false, true);
                SemanticSummaryPluginAction init = new SemanticSummaryPluginAction();
                init.loadCloudPanel();
            }
        }
    }
}

