/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.EditCloudNameDialog;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CytoscapeDesktop;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class CloudListMouseListener
extends MouseAdapter {
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.rightClickList(e);
        } else {
            this.leftClickList(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.rightClickList(e);
        } else {
            this.leftClickList(e);
        }
    }

    private void rightClickList(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)((Object)new ChangeCloudNameAction()));
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private void leftClickList(MouseEvent e) {
        int clickIndex;
        Point selPoint = new Point(e.getX(), e.getY());
        JList cloudList = SemanticSummaryManager.getInstance().getInputWindow().getCloudList();
        int selIndex = cloudList.getSelectedIndex();
        if (selIndex == (clickIndex = cloudList.locationToIndex(selPoint))) {
            cloudList.clearSelection();
            cloudList.setSelectedIndex(selIndex);
        }
    }

    public class ChangeCloudNameAction
    extends CytoscapeAction {
        private static final long serialVersionUID = 3741354852598317680L;

        public ChangeCloudNameAction() {
            super("Edit Cloud Name");
        }

        public void actionPerformed(ActionEvent ae) {
            String newName;
            String curName;
            DefaultListModel listValues;
            int index;
            JList cloudList;
            block3: {
                CytoscapeDesktop parent = Cytoscape.getDesktop();
                cloudList = SemanticSummaryManager.getInstance().getInputWindow().getCloudList();
                index = cloudList.getSelectedIndex();
                if (index == -1) {
                    JOptionPane.showMessageDialog((Component)parent, "You must fist select a Cloud.");
                    return;
                }
                listValues = SemanticSummaryManager.getInstance().getInputWindow().getListValues();
                curName = (String)listValues.get(index);
                newName = "";
                int value = 1;
                Object[] options = new Object[]{"Try Again", "Cancel"};
                do {
                    EditCloudNameDialog theDialog = new EditCloudNameDialog((Component)parent, true, curName);
                    theDialog.setLocationRelativeTo((Component)parent);
                    theDialog.setVisible(true);
                    newName = theDialog.getNewCloudName();
                    if (curName.equals(newName)) break block3;
                    if (newName == null || newName.trim().equals("")) {
                        newName = curName;
                        break block3;
                    }
                    if (!this.isCloudNameTaken(newName)) break block3;
                } while ((value = JOptionPane.showOptionDialog((Component)parent, "That cloud name already exists, try again.", "Duplicate Cloud Name", 2, 1, null, options, options[0])) != 1);
                newName = curName;
            }
            CloudParameters cloudParams = SemanticSummaryManager.getInstance().getCurCloud();
            SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCurNetwork();
            networkParams.getClouds().remove(curName);
            cloudParams.setCloudName(newName);
            networkParams.addCloud(newName, cloudParams);
            listValues.setElementAt(newName, index);
            cloudList.updateUI();
        }

        public boolean isCloudNameTaken(String name) {
            return SemanticSummaryManager.getInstance().getCurNetwork().containsCloud(name);
        }
    }
}

