/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudDisplayPanel;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryInputPanel;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryPluginAction;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JOptionPane;

public class CreateCloudAction
extends CytoscapeAction {
    private static final long serialVersionUID = 1103296239269358444L;

    public CreateCloudAction() {
        super("Create Cloud");
    }

    public void actionPerformed(ActionEvent ae) {
        SemanticSummaryParameters params;
        SemanticSummaryPluginAction init = new SemanticSummaryPluginAction();
        init.actionPerformed(ae);
        CyNetwork network = Cytoscape.getCurrentNetwork();
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        if (network == null || view == null) {
            return;
        }
        if (network.getSelectedNodes().size() == 0) {
            JOptionPane.showMessageDialog(view.getComponent(), "Please select one or more nodes.");
            return;
        }
        String networkID = network.getIdentifier();
        if (SemanticSummaryManager.getInstance().isSemanticSummary(networkID)) {
            params = SemanticSummaryManager.getInstance().getParameters(networkID);
            if (params.networkHasChanged(network)) {
                // empty if block
            }
            params.updateParameters(network);
        } else {
            params = new SemanticSummaryParameters();
            params.updateParameters(network);
            SemanticSummaryManager.getInstance().registerNetwork(network, params);
        }
        CloudParameters cloudParams = new CloudParameters();
        cloudParams.setCloudNum(params.getCloudCount());
        cloudParams.setCloudName(params.getNextCloudName());
        cloudParams.setNetworkParams(params);
        cloudParams.setNetworkNumNodes(network.getNodeCount() * cloudParams.getAttributeNames().size());
        Set nodes = network.getSelectedNodes();
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (CyNode curNode : nodes) {
            String curName = curNode.toString();
            nodeNames.add(curName);
        }
        cloudParams.setSelectedNodes(nodeNames);
        cloudParams.setSelectedNumNodes(nodeNames.size());
        params.addCloud(cloudParams.getCloudName(), cloudParams);
        cloudParams.retrieveInputVals();
        cloudParams.updateRatios();
        cloudParams.calculateFontSizes();
        CloudDisplayPanel cloudPanel = SemanticSummaryManager.getInstance().getCloudWindow();
        cloudPanel.updateCloudDisplay(cloudParams);
        SemanticSummaryInputPanel inputPanel = SemanticSummaryManager.getInstance().getInputWindow();
        inputPanel.addNewCloud(cloudParams);
        inputPanel.getCreateNetworkButton().setEnabled(true);
        inputPanel.refreshNetworkSettings();
        inputPanel.getAddWordTextField().setEditable(true);
        inputPanel.getAddWordButton().setEnabled(true);
    }
}

