/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud.test;

import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CloudWordInfo;
import cytoscape.csplugins.wordcloud.SemanticSummaryClusterBuilder;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SingleWordCluster;
import cytoscape.csplugins.wordcloud.WordClusters;
import cytoscape.csplugins.wordcloud.WordPair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class SemanticSummaryClusterBuilderUnitTest
extends TestCase {
    String cloudName = "CloudName";
    SemanticSummaryParameters parentParams;
    CloudParameters cloudParams;

    @Before
    public void setUp() throws Exception {
        this.parentParams = new SemanticSummaryParameters();
        ArrayList<CyNode> allNodes = new ArrayList<CyNode>();
        CyNode node1 = Cytoscape.getCyNode((String)"Regulation of apoptosis", (boolean)true);
        CyNode node2 = Cytoscape.getCyNode((String)"Positive regulation of apoptosis", (boolean)true);
        CyNode node3 = Cytoscape.getCyNode((String)"Positive regulation of programmed cell death", (boolean)true);
        CyNode node4 = Cytoscape.getCyNode((String)"Immune response", (boolean)true);
        CyNode node5 = Cytoscape.getCyNode((String)"Activation of immune response", (boolean)true);
        CyNode node6 = Cytoscape.getCyNode((String)"Activation of humoral immune response", (boolean)true);
        allNodes.add(node1);
        allNodes.add(node2);
        allNodes.add(node3);
        allNodes.add(node4);
        allNodes.add(node5);
        allNodes.add(node6);
        this.cloudParams = new CloudParameters();
        this.cloudParams.setCloudName(this.cloudName);
        this.cloudParams.setNetworkParams(this.parentParams);
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator iter = allNodes.iterator();
        while (iter.hasNext()) {
            nodeNames.add(((CyNode)iter.next()).toString());
        }
        this.parentParams.setNetworkNodes(nodeNames);
        this.cloudParams.setSelectedNodes(nodeNames);
        this.cloudParams.setSelectedNumNodes(6);
        this.cloudParams.setNetworkNumNodes(6);
        this.parentParams.addCloud(this.cloudName, this.cloudParams);
    }

    @Test
    public void testInitialize() {
        SemanticSummaryClusterBuilder builder = new SemanticSummaryClusterBuilder();
        builder.initialize(this.cloudParams);
        ArrayList<WordPair> pair = builder.getQueue().getQueue();
        WordPair firstPair = pair.get(0);
        String word1 = firstPair.getFirstWord();
        String word2 = firstPair.getSecondWord();
        Double val = firstPair.getProbability();
        SemanticSummaryClusterBuilderUnitTest.assertTrue(word1.equals("programmed"));
        SemanticSummaryClusterBuilderUnitTest.assertTrue(word2.equals("cell"));
        SemanticSummaryClusterBuilderUnitTest.assertTrue(val == 6.0);
        WordClusters clusters = builder.getClusters();
        ArrayList<SingleWordCluster> wordClusters = clusters.getClusters();
        int size = wordClusters.size();
        SemanticSummaryClusterBuilderUnitTest.assertTrue(size == 10);
    }

    @Test
    public void testClusterData() {
        SemanticSummaryClusterBuilder builder = new SemanticSummaryClusterBuilder();
        builder.initialize(this.cloudParams);
        builder.clusterData(3.0);
        ArrayList<WordPair> pair = builder.getQueue().getQueue();
        WordPair firstPair = pair.get(0);
        String word1 = firstPair.getFirstWord();
        String word2 = firstPair.getSecondWord();
        Double val = firstPair.getProbability();
        SemanticSummaryClusterBuilderUnitTest.assertTrue(word1.equals("immune"));
        SemanticSummaryClusterBuilderUnitTest.assertTrue(word2.equals("response"));
        SemanticSummaryClusterBuilderUnitTest.assertTrue(val == 2.0);
        WordClusters clusters = builder.getClusters();
        ArrayList<SingleWordCluster> wordClusters = clusters.getClusters();
        int size = wordClusters.size();
        SemanticSummaryClusterBuilderUnitTest.assertTrue(size == 7);
    }

    @Test
    public void testBuildCloudWords() {
        SemanticSummaryClusterBuilder builder = new SemanticSummaryClusterBuilder();
        builder.initialize(this.cloudParams);
        builder.clusterData(3.0);
        builder.buildCloudWords();
        ArrayList<CloudWordInfo> info = builder.getCloudWords();
        CloudWordInfo first = info.get(0);
        int firstSize = first.getFontSize();
        String firstWord = first.getWord();
        int firstCluster = first.getCluster();
        Color firstColor = first.getTextColor();
        SemanticSummaryClusterBuilderUnitTest.assertTrue(firstSize == SemanticSummaryManager.getInstance().getNullSemanticSummary().getMaxFont());
        SemanticSummaryClusterBuilderUnitTest.assertTrue(firstWord.equals("regulation"));
        SemanticSummaryClusterBuilderUnitTest.assertTrue(firstCluster == 0);
        SemanticSummaryClusterBuilderUnitTest.assertTrue(firstColor.equals(Color.BLACK));
        int lastSize = info.size() - 1;
        CloudWordInfo last = info.get(lastSize);
        int lastFontSize = last.getFontSize();
        String lastWord = last.getWord();
        int lastCluster = last.getCluster();
        Color lastColor = last.getTextColor();
        SemanticSummaryClusterBuilderUnitTest.assertTrue(lastFontSize == SemanticSummaryManager.getInstance().getNullSemanticSummary().getMinFont());
        SemanticSummaryClusterBuilderUnitTest.assertTrue(lastWord.equals("death"));
        SemanticSummaryClusterBuilderUnitTest.assertTrue(lastCluster == 6);
        SemanticSummaryClusterBuilderUnitTest.assertTrue(lastColor.equals(Color.GRAY));
    }
}

