/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.CloudParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordPair
implements Comparable<WordPair> {
    private String firstWord;
    private String secondWord;
    private Double probability;
    private CloudParameters params;
    private static final char controlChar = '\u001f';

    public WordPair(String aWord, String nextWord, CloudParameters cloudParams) {
        this.firstWord = aWord;
        this.secondWord = nextWord;
        this.params = cloudParams;
        this.probability = 0.0;
    }

    public void calculateProbability() {
        Integer total = this.params.getSelectedNumNodes();
        Integer firstCount = this.params.getSelectedCounts().get(this.firstWord);
        Integer secondCount = this.params.getSelectedCounts().get(this.secondWord);
        String pairName = this.firstWord + '\u001f' + this.secondWord;
        Integer pairCount = this.params.getSelectedPairCounts().get(pairName);
        Integer numerator = pairCount * total;
        Double doubleNumerator = numerator.doubleValue();
        Integer denominator = firstCount * secondCount;
        Double doubleDenom = denominator.doubleValue();
        this.probability = doubleNumerator / doubleDenom;
    }

    @Override
    public int compareTo(WordPair second) {
        Double firstProb = this.probability;
        Double secondProb = second.probability;
        if (firstProb < secondProb) {
            return -1;
        }
        if (firstProb > secondProb) {
            return 1;
        }
        String firstWordPair = this.getWordPairing();
        String secondWordPair = second.getWordPairing();
        Double firstRatio = this.getCloudParameters().getPairRatios().get(firstWordPair);
        Double secondRatio = second.getCloudParameters().getPairRatios().get(secondWordPair);
        if (firstRatio < secondRatio) {
            return -1;
        }
        if (firstRatio > secondRatio) {
            return 1;
        }
        return firstWordPair.compareTo(secondWordPair);
    }

    public void setFirstWord(String aWord) {
        this.firstWord = aWord;
    }

    public String getFirstWord() {
        return this.firstWord;
    }

    public void setSecondWord(String aWord) {
        this.secondWord = aWord;
    }

    public String getSecondWord() {
        return this.secondWord;
    }

    public void setCloudParameters(CloudParameters aParam) {
        this.params = aParam;
    }

    public CloudParameters getCloudParameters() {
        return this.params;
    }

    public Double getProbability() {
        return this.probability;
    }

    public String getWordPairing() {
        return this.firstWord + '\u001f' + this.secondWord;
    }
}

