/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.csplugins.wordcloud.CloudDisplayStyles;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CloudWordInfo;
import cytoscape.csplugins.wordcloud.ModifiedClusterFlowLayout;
import cytoscape.csplugins.wordcloud.ModifiedFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class CloudDisplayPanel
extends JPanel {
    private static final long serialVersionUID = 5996569544692738989L;
    JPanel tagCloudFlowPanel;
    JScrollPane cloudScroll;
    CloudParameters curCloud;

    public CloudDisplayPanel() {
        this.setLayout(new BorderLayout());
        this.tagCloudFlowPanel = this.initializeTagCloud();
        this.cloudScroll = new JScrollPane(this.tagCloudFlowPanel);
        this.cloudScroll.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.cloudScroll, "Center");
    }

    private JPanel initializeTagCloud() {
        JPanel panel = new JPanel(new ModifiedFlowLayout(1, 30, 25));
        return panel;
    }

    public void clearCloud() {
        this.tagCloudFlowPanel.removeAll();
        this.tagCloudFlowPanel.setLayout(new ModifiedFlowLayout(1, 30, 25));
        this.tagCloudFlowPanel.revalidate();
        this.cloudScroll.revalidate();
        this.tagCloudFlowPanel.updateUI();
        this.curCloud = null;
    }

    public void updateCloudDisplay(CloudParameters params) {
        JPanel curPanel;
        this.clearCloud();
        this.curCloud = params;
        ArrayList<CloudWordInfo> copy = new ArrayList<CloudWordInfo>();
        ArrayList<CloudWordInfo> original = this.curCloud.getCloudWordInfoList();
        for (int i = 0; i < original.size(); ++i) {
            CloudWordInfo curInfo = original.get(i);
            copy.add(curInfo);
        }
        Collections.sort(copy);
        Integer max = params.getMaxWords();
        Integer numWords = copy.size();
        if (max < numWords) {
            copy.subList(max, numWords).clear();
        }
        int count = 0;
        HashMap<Integer, JPanel> clusters = new HashMap<Integer, JPanel>();
        ArrayList<CloudWordInfo> wordInfo = this.curCloud.getCloudWordInfoList();
        Iterator<CloudWordInfo> iter = wordInfo.iterator();
        while (iter.hasNext() && count < params.getMaxWords()) {
            CloudWordInfo curWordInfo = iter.next();
            if (!copy.contains(curWordInfo)) continue;
            Integer clusterNum = curWordInfo.getCluster();
            JLabel curLabel = curWordInfo.createCloudLabel();
            if (clusters.containsKey(clusterNum)) {
                curPanel = (JPanel)clusters.get(clusterNum);
            } else {
                if (params.getDisplayStyle().equals(CloudDisplayStyles.NO_CLUSTERING)) {
                    curPanel = this.tagCloudFlowPanel;
                    curPanel.setLayout(new ModifiedFlowLayout(1, 10, 0));
                } else {
                    curPanel = new JPanel(new ModifiedClusterFlowLayout(1, 10, 0));
                }
                if (params.getDisplayStyle().equals(CloudDisplayStyles.CLUSTERED_BOXES)) {
                    curPanel.setBorder(new CompoundBorder(BorderFactory.createLineBorder(Color.GRAY), new EmptyBorder(10, 10, 10, 10)));
                }
            }
            curPanel.add(curLabel);
            clusters.put(clusterNum, curPanel);
            ++count;
        }
        TreeSet sortedSet = new TreeSet(clusters.keySet());
        for (Integer clusterNum : sortedSet) {
            curPanel = (JPanel)clusters.get(clusterNum);
            if (curPanel.equals(this.tagCloudFlowPanel)) continue;
            this.tagCloudFlowPanel.add(curPanel);
        }
        this.tagCloudFlowPanel.revalidate();
        this.revalidate();
        this.updateUI();
        this.repaint();
    }

    public JPanel getTagCloudFlowPanel() {
        return this.tagCloudFlowPanel;
    }

    public void setTagCloudFlowPanel(JPanel aPanel) {
        this.tagCloudFlowPanel = aPanel;
    }

    public CloudParameters getCloudParameters() {
        return this.curCloud;
    }

    public void setCloudParameters(CloudParameters params) {
        this.curCloud = params;
    }
}

