/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CreateCloudNetworkAction;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.awt.Color;

public class WordCloudVisualStyle {
    private String networkName;
    private VisualStyle vs;
    private CloudParameters cloudParams;

    public WordCloudVisualStyle(String string, String name, CloudParameters params) {
        this.networkName = name;
        this.vs = new VisualStyle(string);
        this.cloudParams = params;
    }

    public VisualStyle createVisualStyle(CyNetwork network, String name) {
        GlobalAppearanceCalculator globalAppCalc = new GlobalAppearanceCalculator();
        globalAppCalc.setDefaultBackgroundColor(new Color(205, 205, 235));
        this.vs.setGlobalAppearanceCalculator(globalAppCalc);
        this.createEdgeAppearance(network, name);
        this.createNodeAppearance(network, name);
        return this.vs;
    }

    private void createEdgeAppearance(CyNetwork network, String name) {
        EdgeAppearanceCalculator edgeAppCalc = new EdgeAppearanceCalculator(this.vs.getDependency());
        EdgeAppearance edgeAppear = new EdgeAppearance();
        edgeAppear.set(VisualPropertyType.EDGE_COLOR, (Object)new Color(100, 200, 0));
        edgeAppCalc.setDefaultAppearance(edgeAppear);
        ContinuousMapping continuousMapping_edgeWidth = new ContinuousMapping((Object)1, 0);
        continuousMapping_edgeWidth.setControllingAttributeName(name + ":" + CreateCloudNetworkAction.CO_VAL, network, false);
        LinearNumberToNumberInterpolator numTonum2 = new LinearNumberToNumberInterpolator();
        continuousMapping_edgeWidth.setInterpolator((Interpolator)numTonum2);
        Double under_width = 0.5;
        Double min_width = 1.0;
        Double max_width = 8.0;
        Double over_width = 9.0;
        BoundaryRangeValues bv4 = new BoundaryRangeValues((Object)under_width, (Object)min_width, (Object)min_width);
        BoundaryRangeValues bv5 = new BoundaryRangeValues((Object)max_width, (Object)max_width, (Object)over_width);
        continuousMapping_edgeWidth.addPoint(1.0, bv4);
        continuousMapping_edgeWidth.addPoint(40.0, bv5);
        BasicCalculator edgeWidthCalculator = new BasicCalculator(name + "edgesize", (ObjectMapping)continuousMapping_edgeWidth, VisualPropertyType.EDGE_LINE_WIDTH);
        edgeAppCalc.setCalculator((Calculator)edgeWidthCalculator);
        this.vs.setEdgeAppearanceCalculator(edgeAppCalc);
    }

    private void createNodeAppearance(CyNetwork network, String name) {
        NodeAppearanceCalculator nodeAppCalc = new NodeAppearanceCalculator(this.vs.getDependency());
        NodeAppearance nodeAppear = new NodeAppearance();
        nodeAppear.set(VisualPropertyType.NODE_FILL_COLOR, (Object)Color.GRAY);
        nodeAppear.set(VisualPropertyType.NODE_BORDER_COLOR, (Object)Color.GRAY);
        nodeAppear.set(VisualPropertyType.NODE_SHAPE, (Object)NodeShape.ELLIPSE);
        nodeAppear.set(VisualPropertyType.NODE_SIZE, (Object)new Double(35.0));
        nodeAppear.set(VisualPropertyType.NODE_LINE_WIDTH, (Object)new Double(4.0));
        nodeAppCalc.setDefaultAppearance(nodeAppear);
        ContinuousMapping continuousMapping_size = new ContinuousMapping((Object)35, 1);
        continuousMapping_size.setControllingAttributeName(name + ":" + CreateCloudNetworkAction.WORD_VAL, network, false);
        LinearNumberToNumberInterpolator numTonum = new LinearNumberToNumberInterpolator();
        continuousMapping_size.setInterpolator((Interpolator)numTonum);
        Integer min = 20;
        Integer max = 65;
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)min, (Object)min, (Object)min);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)max, (Object)max, (Object)max);
        continuousMapping_size.addPoint(this.cloudParams.getMinRatio().doubleValue(), bv0);
        continuousMapping_size.addPoint(this.cloudParams.getMaxRatio().doubleValue(), bv1);
        BasicCalculator nodeSizeCalculator = new BasicCalculator(name + "size2size", (ObjectMapping)continuousMapping_size, VisualPropertyType.NODE_SIZE);
        nodeAppCalc.setCalculator((Calculator)nodeSizeCalculator);
        PassThroughMapping pm = new PassThroughMapping((Object)new String(), "canonicalName");
        BasicCalculator nlc = new BasicCalculator(name + "nodeLabel", (ObjectMapping)pm, VisualPropertyType.NODE_LABEL);
        nodeAppCalc.setCalculator((Calculator)nlc);
        ContinuousMapping continuousMapping_labelSize = new ContinuousMapping((Object)35, 1);
        continuousMapping_labelSize.setControllingAttributeName(name + ":" + CreateCloudNetworkAction.WORD_VAL, network, false);
        LinearNumberToNumberInterpolator numTonum2 = new LinearNumberToNumberInterpolator();
        continuousMapping_labelSize.setInterpolator((Interpolator)numTonum2);
        min = 12;
        max = 56;
        bv0 = new BoundaryRangeValues((Object)min, (Object)min, (Object)min);
        bv1 = new BoundaryRangeValues((Object)max, (Object)max, (Object)max);
        continuousMapping_labelSize.addPoint(this.cloudParams.getMinRatio().doubleValue(), bv0);
        continuousMapping_labelSize.addPoint(this.cloudParams.getMaxRatio().doubleValue(), bv1);
        BasicCalculator labelSizeCalculator = new BasicCalculator(name + "size2label", (ObjectMapping)continuousMapping_labelSize, VisualPropertyType.NODE_FONT_SIZE);
        nodeAppCalc.setCalculator((Calculator)labelSizeCalculator);
        this.vs.setNodeAppearanceCalculator(nodeAppCalc);
    }
}

