/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.CreateCloudAction;
import cytoscape.csplugins.wordcloud.SemanticSummaryManager;
import cytoscape.csplugins.wordcloud.SemanticSummaryNetworkListener;
import cytoscape.csplugins.wordcloud.SemanticSummaryNodeContextMenuListener;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryPluginAction;
import cytoscape.csplugins.wordcloud.ShowAboutPanelAction;
import cytoscape.csplugins.wordcloud.WordDelimiters;
import cytoscape.csplugins.wordcloud.WordFilter;
import cytoscape.data.readers.TextFileReader;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.util.CytoscapeAction;
import ding.view.DGraphView;
import ding.view.NodeContextMenuListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticSummaryPlugin
extends CytoscapePlugin {
    private static final String netNameSep = "SemanticSummaryNetworkSeparator";
    private static final String cloudNameSep = "SemanticSummaryCloudSeparator";

    public SemanticSummaryPlugin() {
        SemanticSummaryPluginAction settings = new SemanticSummaryPluginAction();
        CreateCloudAction create = new CreateCloudAction();
        ShowAboutPanelAction about = new ShowAboutPanelAction();
        create.setPreferredMenu("Plugins.WordCloud");
        settings.setPreferredMenu("Plugins.WordCloud");
        about.setPreferredMenu("Plugins.WordCloud");
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)create);
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)settings);
        Cytoscape.getDesktop().getCyMenus().addAction((CytoscapeAction)about);
        SemanticSummaryNetworkListener netListener = new SemanticSummaryNetworkListener();
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(netListener);
        Set networkSet = Cytoscape.getNetworkSet();
        for (CyNetwork network : networkSet) {
            SemanticSummaryNodeContextMenuListener nodeMenuListener = new SemanticSummaryNodeContextMenuListener();
            ((DGraphView)Cytoscape.getNetworkView((String)network.getIdentifier())).addNodeContextMenuListener((NodeContextMenuListener)nodeMenuListener);
        }
    }

    public String describe() {
        StringBuffer sb = new StringBuffer();
        sb.append("For every node in the current network, this plugin ");
        sb.append("displays a word cloud of the selected ");
        sb.append("cyNode attribute.  The node ID is the defuault ");
        sb.append("attribute.");
        return sb.toString();
    }

    public void onCytoscapeExit() {
    }

    public void saveSessionStateFiles(List<File> pFileList) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        System.out.println("java.io.tmpdir: [" + tmpDir + "]");
        HashMap<String, SemanticSummaryParameters> networks = SemanticSummaryManager.getInstance().getCyNetworkList();
        Iterator<String> iter = networks.keySet().iterator();
        while (iter.hasNext()) {
            String networkID = iter.next().toString();
            SemanticSummaryParameters params = networks.get(networkID);
            String networkName = params.getNetworkName();
            CyNetwork network = Cytoscape.getNetwork((String)networkID);
            if (params.networkHasChanged(network)) {
                // empty if block
            }
            params.updateParameters(network);
            File session_prop_file = new File(tmpDir, netNameSep + networkName + netNameSep + ".props");
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(session_prop_file));
                writer.write(params.toString());
                writer.close();
                File current_filter = new File(tmpDir, netNameSep + networkName + netNameSep + ".FILTER.txt");
                BufferedWriter filterWriter = new BufferedWriter(new FileWriter(current_filter));
                filterWriter.write(params.getFilter().toString());
                filterWriter.close();
                pFileList.add(current_filter);
                File current_delimiter = new File(tmpDir, netNameSep + networkName + netNameSep + ".DELIMITER.txt");
                BufferedWriter delimiterWriter = new BufferedWriter(new FileWriter(current_delimiter));
                delimiterWriter.write(params.getDelimiter().toString());
                delimiterWriter.close();
                pFileList.add(current_delimiter);
                if (!params.getClouds().isEmpty()) {
                    HashMap<String, CloudParameters> all_clouds = params.getClouds();
                    Iterator<String> j = all_clouds.keySet().iterator();
                    while (j.hasNext()) {
                        String cloud_name = j.next().toString();
                        CloudParameters cloud = all_clouds.get(cloud_name);
                        File current_cloud = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".CLOUDS.txt");
                        BufferedWriter subCloud1Writer = new BufferedWriter(new FileWriter(current_cloud));
                        subCloud1Writer.write(cloud.toString());
                        subCloud1Writer.close();
                        pFileList.add(current_cloud);
                        File current_mapping = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".MAPPING.txt");
                        BufferedWriter subCloud2Writer = new BufferedWriter(new FileWriter(current_mapping));
                        subCloud2Writer.write(cloud.printHashMap(cloud.getStringNodeMapping()));
                        subCloud2Writer.close();
                        pFileList.add(current_mapping);
                        File current_net_counts = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".NETCOUNTS.txt");
                        BufferedWriter subCloud3Writer = new BufferedWriter(new FileWriter(current_net_counts));
                        subCloud3Writer.write(cloud.printHashMap(cloud.getNetworkCounts()));
                        subCloud3Writer.close();
                        pFileList.add(current_net_counts);
                        File current_sel_counts = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".SELCOUNTS.txt");
                        BufferedWriter subCloud4Writer = new BufferedWriter(new FileWriter(current_sel_counts));
                        subCloud4Writer.write(cloud.printHashMap(cloud.getSelectedCounts()));
                        subCloud4Writer.close();
                        pFileList.add(current_sel_counts);
                        File current_ratios = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".RATIOS.txt");
                        BufferedWriter subCloud5Writer = new BufferedWriter(new FileWriter(current_ratios));
                        subCloud5Writer.write(cloud.printHashMap(cloud.getRatios()));
                        subCloud5Writer.close();
                        pFileList.add(current_ratios);
                        File current_net_pairCounts = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".NETPAIRCOUNTS.txt");
                        BufferedWriter subCloud6Writer = new BufferedWriter(new FileWriter(current_net_pairCounts));
                        subCloud6Writer.write(cloud.printHashMap(cloud.getNetworkPairCounts()));
                        subCloud6Writer.close();
                        pFileList.add(current_net_pairCounts);
                        File current_sel_pairCounts = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".SELPAIRCOUNTS.txt");
                        BufferedWriter subCloud7Writer = new BufferedWriter(new FileWriter(current_sel_pairCounts));
                        subCloud7Writer.write(cloud.printHashMap(cloud.getSelectedPairCounts()));
                        subCloud7Writer.close();
                        pFileList.add(current_sel_pairCounts);
                        File current_pairRatios = new File(tmpDir, netNameSep + networkName + netNameSep + cloudNameSep + cloud_name + cloudNameSep + ".PAIRRATIOS.txt");
                        BufferedWriter subCloud8Writer = new BufferedWriter(new FileWriter(current_pairRatios));
                        subCloud8Writer.write(cloud.printHashMap(cloud.getPairRatios()));
                        subCloud8Writer.close();
                        pFileList.add(current_pairRatios);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            pFileList.add(session_prop_file);
        }
    }

    public void restoreSessionState(List<File> pStateFileList) {
        if (pStateFileList == null || pStateFileList.size() == 0) {
            return;
        }
        SemanticSummaryManager.getInstance();
        SemanticSummaryPluginAction init = new SemanticSummaryPluginAction();
        init.loadInputPanel();
        init.loadCloudPanel();
        try {
            String net_name;
            String[] fullname;
            String[] fullname2;
            Object params;
            String fullText;
            TextFileReader reader;
            File prop_file;
            int i;
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                if (!prop_file.getName().contains(".props")) continue;
                reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                fullText = reader.getText();
                params = new SemanticSummaryParameters(fullText);
                fullname2 = prop_file.getName().split(netNameSep);
                String props_name = fullname2[1];
                SemanticSummaryManager.getInstance().registerNetwork(Cytoscape.getNetwork((String)props_name), (SemanticSummaryParameters)params);
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                SemanticSummaryParameters networkParams;
                prop_file = pStateFileList.get(i);
                if (prop_file.getName().contains(".CLOUDS.txt")) {
                    reader = new TextFileReader(prop_file.getAbsolutePath());
                    reader.read();
                    fullText = reader.getText();
                    params = new CloudParameters(fullText);
                    fullname2 = prop_file.getName().split(netNameSep);
                    String net_name2 = fullname2[1];
                    String[] fullname22 = prop_file.getName().split(cloudNameSep);
                    String cloud_name = fullname22[1];
                    SemanticSummaryParameters networkParams2 = SemanticSummaryManager.getInstance().getCyNetworkList().get(net_name2);
                    ((CloudParameters)params).setNetworkParams(networkParams2);
                    networkParams2.addCloud(cloud_name, (CloudParameters)params);
                }
                if (prop_file.getName().contains(".FILTER.txt")) {
                    reader = new TextFileReader(prop_file.getAbsolutePath());
                    reader.read();
                    fullText = reader.getText();
                    fullname = prop_file.getName().split(netNameSep);
                    net_name = fullname[1];
                    networkParams = SemanticSummaryManager.getInstance().getCyNetworkList().get(net_name);
                    WordFilter curFilter = new WordFilter(fullText);
                    networkParams.setFilter(curFilter);
                }
                if (!prop_file.getName().contains(".DELIMITER.txt")) continue;
                reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                fullText = reader.getText();
                fullname = prop_file.getName().split(netNameSep);
                net_name = fullname[1];
                networkParams = SemanticSummaryManager.getInstance().getCyNetworkList().get(net_name);
                WordDelimiters curDelimiter = new WordDelimiters(fullText);
                networkParams.setDelimiter(curDelimiter);
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                if (prop_file.getName().contains(".CLOUDS.txt") || prop_file.getName().contains(".props") || prop_file.getName().contains(".FILTER.txt") || prop_file.getName().contains(".DELIMITER.txt")) continue;
                reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                fullText = reader.getText();
                fullname = prop_file.getName().split(netNameSep);
                net_name = fullname[1];
                String[] fullname23 = prop_file.getName().split(cloudNameSep);
                String cloud_name = fullname23[1];
                SemanticSummaryParameters networkParams = SemanticSummaryManager.getInstance().getCyNetworkList().get(net_name);
                CloudParameters cloudParams = networkParams.getCloud(cloud_name);
                if (prop_file.getName().contains(".MAPPING.txt")) {
                    HashMap mappings = cloudParams.repopulateHashmap(fullText, 2);
                    cloudParams.setStringNodeMapping(mappings);
                }
                if (prop_file.getName().contains(".NETCOUNTS.txt")) {
                    HashMap netCounts = cloudParams.repopulateHashmap(fullText, 1);
                    cloudParams.setNetworkCounts(netCounts);
                }
                if (prop_file.getName().contains(".NETPAIRCOUNTS.txt")) {
                    HashMap netPairCounts = cloudParams.repopulateHashmap(fullText, 1);
                    cloudParams.setNetworkPairCounts(netPairCounts);
                }
                if (prop_file.getName().contains(".SELCOUNTS.txt")) {
                    HashMap selCounts = cloudParams.repopulateHashmap(fullText, 1);
                    cloudParams.setSelectedCounts(selCounts);
                }
                if (prop_file.getName().contains(".SELPAIRCOUNTS.txt")) {
                    HashMap selPairCounts = cloudParams.repopulateHashmap(fullText, 1);
                    cloudParams.setSelectedPairCounts(selPairCounts);
                }
                if (prop_file.getName().contains(".RATIOS.txt")) {
                    HashMap ratios = cloudParams.repopulateHashmap(fullText, 3);
                    cloudParams.setRatios(ratios);
                }
                if (!prop_file.getName().contains(".PAIRRATIOS.txt")) continue;
                HashMap pairRatios = cloudParams.repopulateHashmap(fullText, 3);
                cloudParams.setPairRatios(pairRatios);
            }
            SemanticSummaryManager.getInstance().setupCurrentNetwork();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties getPropertiesFromClasspath(String propFileName) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }
}

