/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.csplugins.wordcloud.test;

import cytoscape.csplugins.wordcloud.CloudParameters;
import cytoscape.csplugins.wordcloud.SemanticSummaryParameters;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class SemanticSummaryParametersUnitTest
extends TestCase {
    SemanticSummaryParameters params = new SemanticSummaryParameters();
    String cloudName = "Test Cloud";
    String nonName = "Other Cloud";
    CloudParameters cloudParams = new CloudParameters();
    CloudParameters nonParams = new CloudParameters();

    @Before
    public void setUp() {
        this.cloudParams.setCloudName(this.cloudName);
        this.nonParams.setCloudName(this.nonName);
    }

    @Test
    public void testAddCloud() {
        CloudParameters retrieved = this.params.getCloud(this.cloudName);
        SemanticSummaryParametersUnitTest.assertTrue(retrieved == null);
        this.params.addCloud(this.cloudName, this.cloudParams);
        retrieved = this.params.getCloud(this.cloudName);
        SemanticSummaryParametersUnitTest.assertTrue(this.params.containsCloud(this.cloudName));
        SemanticSummaryParametersUnitTest.assertTrue(retrieved.equals(this.cloudParams));
    }

    @Test
    public void testRemoveCloud() {
        this.params.addCloud(this.cloudName, this.cloudParams);
        SemanticSummaryParametersUnitTest.assertTrue(this.params.containsCloud(this.cloudName));
        this.params.removeCloud(this.nonName);
        SemanticSummaryParametersUnitTest.assertTrue(this.params.containsCloud(this.cloudName));
        this.params.removeCloud(this.cloudName);
        SemanticSummaryParametersUnitTest.assertFalse(this.params.containsCloud(this.cloudName));
    }

    @Test
    public void testNetworkChanged() {
        this.params.addCloud(this.cloudName, this.cloudParams);
        this.params.addCloud(this.nonName, this.nonParams);
        this.cloudParams.setRatiosInitialized(true);
        this.cloudParams.setSelInitialized(true);
        this.cloudParams.setCountInitialized(true);
        this.nonParams.setRatiosInitialized(true);
        this.nonParams.setSelInitialized(true);
        this.nonParams.setCountInitialized(true);
        this.params.networkChanged();
        SemanticSummaryParametersUnitTest.assertFalse(this.cloudParams.getRatiosInitialized());
        SemanticSummaryParametersUnitTest.assertFalse(this.cloudParams.getSelInitialized());
        SemanticSummaryParametersUnitTest.assertFalse(this.cloudParams.getCountInitialized());
        SemanticSummaryParametersUnitTest.assertFalse(this.nonParams.getRatiosInitialized());
        SemanticSummaryParametersUnitTest.assertFalse(this.nonParams.getSelInitialized());
        SemanticSummaryParametersUnitTest.assertFalse(this.nonParams.getCountInitialized());
    }

    @Test
    public void testGetNextCloudName() {
        String nextName = this.params.getNextCloudName();
        SemanticSummaryParametersUnitTest.assertEquals(nextName, "Cloud_1");
        nextName = this.params.getNextCloudName();
        SemanticSummaryParametersUnitTest.assertEquals(nextName, "Cloud_2");
    }
}

