/*
 File: CloudDisplayStyles.java

 Copyright 2010 - The Cytoscape Consortium (www.cytoscape.org)
 
 Code written by: Layla Oesper
 Authors: Layla Oesper, Ruth Isserlin, Daniele Merico
 
 This library is free software: you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public License
 along with this project.  If not, see <http://www.gnu.org/licenses/>.
 */

package cytoscape.csplugins.semanticsummary;

/**
 * The CloudDisplayStyles class contains information on the display styles
 * available for the SemanticSummary Cloud.
 * @author Layla Oesper
 * @version 1.0
 */

public class CloudDisplayStyles 
{
	/**
	 * Names of the different styles.
	 */
	
	public static String CLUSTERED_STANDARD = "Clustered-Standard";
	public static String CLUSTERED_BOXES = "Clustered-Boxes";
	public static String NO_CLUSTERING = "No Clustering";
	public static String DEFAULT_STYLE = CLUSTERED_STANDARD;
}
