/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.util.swing.BasicCollapsiblePanel;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;

public class AcademiaPanel {
    private JPanel academiaInfoPanelRef = null;
    private JTextField facultyTextFieldRef = new JTextField();
    private JTextField pathTextFieldRef = new JTextField();
    private JTextArea thresholdTextAreaRef = null;
    private JRadioButton incitesRadioButtonRef = null;
    private JRadioButton pubmedRadioButtonRef = null;
    private JRadioButton scopusRadioButtonRef = null;
    private JRadioButton thresholdRadioButtonRef = null;
    private File selectedFileRef = null;
    private SocialNetworkAppManager appManager = null;
    private FileUtil fileUtil = null;
    protected CySwingApplication cySwingAppRef = null;

    public AcademiaPanel(SocialNetworkAppManager appManager, FileUtil fileUtil, CySwingApplication cySwingAppRef) {
        this.appManager = appManager;
        this.fileUtil = fileUtil;
        this.cySwingAppRef = cySwingAppRef;
    }

    public JPanel createAcademiaInfoPanel() {
        JPanel academiaInfoPanel = new JPanel();
        JPanel wrapperPanel = new JPanel();
        wrapperPanel.setLayout(new BorderLayout());
        wrapperPanel.add((Component)this.createDatabaseInfoPanel(), "North");
        wrapperPanel.add((Component)this.createAdvancedOptionsPanel(), "South");
        academiaInfoPanel.setLayout(new BorderLayout());
        academiaInfoPanel.setName("Academia");
        academiaInfoPanel.setBorder(BorderFactory.createTitledBorder("Academia"));
        academiaInfoPanel.add((Component)wrapperPanel, "North");
        this.setAcademiaInfoPanelRef(academiaInfoPanel);
        return academiaInfoPanel;
    }

    private BasicCollapsiblePanel createAdvancedOptionsPanel() {
        BasicCollapsiblePanel advancedOptionsPanel = new BasicCollapsiblePanel("Advanced Options");
        advancedOptionsPanel.setCollapsed(true);
        advancedOptionsPanel.add((Component)this.createThresholdPanel());
        return advancedOptionsPanel;
    }

    private JPanel createDatabaseInfoPanel() {
        JPanel databaseInfoPanel = new JPanel();
        databaseInfoPanel.setBorder(BorderFactory.createTitledBorder("Database"));
        databaseInfoPanel.setLayout(new BoxLayout(databaseInfoPanel, 1));
        databaseInfoPanel.add(this.createDatabasePanel());
        databaseInfoPanel.add(this.createLoadDataPanel());
        databaseInfoPanel.add(this.createSpecifyNetworkNamePanel());
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.add((Component)this.createNetworkButton(), "Center");
        databaseInfoPanel.add(buttonWrapper);
        return databaseInfoPanel;
    }

    private JPanel createDatabasePanel() {
        JPanel databasePanel = new JPanel();
        databasePanel.setBorder(BorderFactory.createTitledBorder("Select Database"));
        databasePanel.setLayout(new BoxLayout(databasePanel, 0));
        this.incitesRadioButtonRef = new JRadioButton("InCites", true);
        this.incitesRadioButtonRef.setFocusable(true);
        this.pubmedRadioButtonRef = new JRadioButton("PubMed", false);
        this.pubmedRadioButtonRef.setFocusable(true);
        this.scopusRadioButtonRef = new JRadioButton("Scopus", false);
        this.scopusRadioButtonRef.setFocusable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.incitesRadioButtonRef);
        buttonGroup.add(this.pubmedRadioButtonRef);
        buttonGroup.add(this.scopusRadioButtonRef);
        databasePanel.add(this.incitesRadioButtonRef);
        databasePanel.add(this.pubmedRadioButtonRef);
        databasePanel.add(this.scopusRadioButtonRef);
        return databasePanel;
    }

    private JButton createLoadButton() {
        JButton loadButton = new JButton("...");
        loadButton.setToolTipText("Load InCites / Scopus data");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FileChooserFilter filter1 = new FileChooserFilter("text file", "txt");
                FileChooserFilter filter2 = new FileChooserFilter("excel spreadsheet(xls)", "xls");
                FileChooserFilter filter3 = new FileChooserFilter("excel spreadsheet(xlsx)", "xlsx");
                FileChooserFilter filter4 = new FileChooserFilter("excel spreadsheet(csv)", "csv");
                FileChooserFilter filter5 = new FileChooserFilter("pubmed report(xml)", "xml");
                HashSet<FileChooserFilter> filters = new HashSet<FileChooserFilter>();
                filters.add(filter1);
                filters.add(filter2);
                filters.add(filter3);
                filters.add(filter4);
                filters.add(filter5);
                File textFile = AcademiaPanel.this.fileUtil.getFile((Component)AcademiaPanel.this.cySwingAppRef.getJFrame(), "Data File Selection", 0, filters);
                AcademiaPanel.this.setDataFile(textFile);
                AcademiaPanel.this.getPathTextFieldRef().setText(textFile.getAbsolutePath());
                AcademiaPanel.this.getFacultyTextFieldRef().setText(AcademiaPanel.this.parseFileName(textFile.getAbsolutePath()));
            }
        });
        return loadButton;
    }

    private JPanel createLoadDataPanel() {
        JPanel loadDataPanel = new JPanel();
        loadDataPanel.setBorder(BorderFactory.createTitledBorder("Load File"));
        loadDataPanel.setLayout(new BoxLayout(loadDataPanel, 0));
        this.setLoadTextField(new JTextField());
        this.getPathTextFieldRef().setEditable(true);
        loadDataPanel.add(this.getPathTextFieldRef());
        loadDataPanel.add(this.createLoadButton());
        return loadDataPanel;
    }

    private JButton createNetworkButton() {
        JButton createNetworkButton = new JButton("Create Network");
        createNetworkButton.setToolTipText("Create network");
        createNetworkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (AcademiaPanel.this.incitesRadioButtonRef.isSelected()) {
                    AcademiaPanel.this.appManager.setAnalysis_type(1410511959);
                }
                if (AcademiaPanel.this.pubmedRadioButtonRef.isSelected()) {
                    AcademiaPanel.this.appManager.setAnalysis_type(-2113004178);
                }
                if (AcademiaPanel.this.scopusRadioButtonRef.isSelected()) {
                    AcademiaPanel.this.appManager.setAnalysis_type(-960949447);
                }
                if (AcademiaPanel.this.getSelectedFileRef() == null || AcademiaPanel.this.getFacultyTextFieldRef().getText() == null) {
                    CytoscapeUtilities.notifyUser("Please select a file and/or specify network name.");
                } else if (!AcademiaPanel.this.getSelectedFileRef().getAbsolutePath().trim().equalsIgnoreCase(AcademiaPanel.this.getPathTextFieldRef().getText().trim())) {
                    CytoscapeUtilities.notifyUser("Please select a file.");
                } else if (AcademiaPanel.this.getFacultyTextFieldRef().getText().trim().isEmpty()) {
                    CytoscapeUtilities.notifyUser("Please specify network name.");
                } else {
                    try {
                        int maxAuthorThreshold = UserPanel.getValidThreshold(true, AcademiaPanel.this.getThresholdTextAreaRef().getText());
                        AcademiaPanel.this.appManager.createNetwork(AcademiaPanel.this.getSelectedFileRef(), maxAuthorThreshold);
                    }
                    catch (FileNotFoundException e) {
                        CytoscapeUtilities.notifyUser(AcademiaPanel.this.getPathTextFieldRef().getText() + " does not exist");
                    }
                }
            }
        });
        return createNetworkButton;
    }

    private JPanel createSpecifyNetworkNamePanel() {
        JPanel specifyNetworkNamePanel = new JPanel();
        specifyNetworkNamePanel.setBorder(BorderFactory.createTitledBorder("Specify Network Name"));
        specifyNetworkNamePanel.setLayout(new BoxLayout(specifyNetworkNamePanel, 0));
        this.setFacultyTextFieldRef(new JTextField());
        this.getFacultyTextFieldRef().setEditable(true);
        specifyNetworkNamePanel.add(this.getFacultyTextFieldRef());
        return specifyNetworkNamePanel;
    }

    private JPanel createThresholdPanel() {
        JPanel thresholdPanel = new JPanel();
        thresholdPanel.setLayout(new BoxLayout(thresholdPanel, 0));
        this.thresholdRadioButtonRef = new JRadioButton("Set max authors per pub");
        this.thresholdRadioButtonRef.setEnabled(true);
        this.thresholdRadioButtonRef.setToolTipText("Set the maximum # of authors to be considered per publication. Publications that exceed the threshold will be excluded.");
        this.thresholdRadioButtonRef.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 || e.getStateChange() == 2) {
                    // empty if block
                }
            }
        });
        thresholdPanel.add(Box.createHorizontalStrut(5));
        thresholdPanel.add(new JLabel("Max authors per pub"));
        thresholdPanel.add(Box.createHorizontalStrut(5));
        thresholdPanel.add(this.getThresholdTextAreaRef());
        return thresholdPanel;
    }

    public JPanel getAcademiaInfoPanelRef() {
        return this.academiaInfoPanelRef;
    }

    public JTextField getFacultyTextFieldRef() {
        return this.facultyTextFieldRef;
    }

    private JTextField getPathTextFieldRef() {
        return this.pathTextFieldRef;
    }

    private File getSelectedFileRef() {
        return this.selectedFileRef;
    }

    public JTextArea getThresholdTextAreaRef() {
        if (this.thresholdTextAreaRef == null) {
            JTextArea textArea = new JTextArea("500");
            Border border = BorderFactory.createLineBorder(Color.GRAY);
            textArea.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.setThresholdTextAreaRef(textArea);
        }
        return this.thresholdTextAreaRef;
    }

    private String parseFileName(String path) {
        Pattern pattern = Pattern.compile("([^\\\\/]+?)(\\.xlsx|\\.txt|\\.csv||\\.xml)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "N/A";
    }

    public void setAcademiaInfoPanelRef(JPanel academiaInfoPanelRef) {
        this.academiaInfoPanelRef = academiaInfoPanelRef;
    }

    private void setDataFile(File selectedFile) {
        this.selectedFileRef = selectedFile;
    }

    private void setFacultyTextFieldRef(JTextField facultyTextField) {
        this.facultyTextFieldRef = facultyTextField;
    }

    private void setLoadTextField(JTextField pathTextField) {
        this.pathTextFieldRef = pathTextField;
    }

    private void setThresholdTextAreaRef(JTextArea thresholdTextFieldRef) {
        this.thresholdTextAreaRef = thresholdTextFieldRef;
    }

    public boolean thresholdIsSelected() {
        if (this.thresholdRadioButtonRef == null) {
            return false;
        }
        return this.thresholdRadioButtonRef.isSelected();
    }
}

