/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.visualstyles;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;

public class VisualStyles {
    private static final Logger logger = Logger.getLogger(VisualStyles.class.getName());
    public static final int DEFAULT_VISUAL_STYLE = -1;
    private static String DEFAULT_VISUAL_STYLE_HELP = null;
    public static final int PUBMED_VISUAL_STYLE = -2113004178;
    private static String PUBMED_VISUAL_STYLE_HELP = null;
    public static final int SCOPUS_VISUAL_STYLE = -960949447;
    private static String SCOPUS_VISUAL_STYLE_HELP = null;
    public static final int INCITES_VISUAL_STYLE = 1410511959;
    private static String INCITES_VISUAL_STYLE_HELP = null;
    private Map<String, Integer> visualStyleMap = null;

    public static String getHelpMessage(int visualStyleType) {
        String fileName = null;
        switch (visualStyleType) {
            case 1410511959: {
                if (INCITES_VISUAL_STYLE_HELP == null) {
                    fileName = "incites_visual_style_help.txt";
                    INCITES_VISUAL_STYLE_HELP = VisualStyles.loadHelpMessage(fileName);
                }
                return INCITES_VISUAL_STYLE_HELP;
            }
            case -2113004178: {
                if (PUBMED_VISUAL_STYLE_HELP == null) {
                    fileName = "pubmed_visual_style_help.txt";
                    PUBMED_VISUAL_STYLE_HELP = VisualStyles.loadHelpMessage(fileName);
                }
                return PUBMED_VISUAL_STYLE_HELP;
            }
            case -960949447: {
                if (SCOPUS_VISUAL_STYLE_HELP == null) {
                    fileName = "scopus_visual_style_help.txt";
                    SCOPUS_VISUAL_STYLE_HELP = VisualStyles.loadHelpMessage(fileName);
                }
                return SCOPUS_VISUAL_STYLE_HELP;
            }
        }
        if (DEFAULT_VISUAL_STYLE_HELP == null) {
            fileName = "default_visual_style_help.txt";
            DEFAULT_VISUAL_STYLE_HELP = VisualStyles.loadHelpMessage(fileName);
        }
        return DEFAULT_VISUAL_STYLE_HELP;
    }

    private static VisualStyles getInstance() {
        return new VisualStyles();
    }

    private static String loadHelpMessage(String fileName) {
        String helpMssg = "";
        try {
            URL url = VisualStyles.getInstance().getClass().getResource(fileName);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String sCurrentLine = null;
            while ((sCurrentLine = br.readLine()) != null) {
                helpMssg = helpMssg + sCurrentLine;
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser(String.format("Failed to load %s. FileNotFoundException.", fileName));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser(String.format("Failed to load %s. IOException.", fileName));
        }
        return helpMssg;
    }

    public int getVisualStyleID(String visualStyle) {
        if (this.visualStyleMap == null) {
            this.visualStyleMap = new HashMap<String, Integer>();
            this.visualStyleMap.put("--SELECT NETWORK VISUAL STYLE--", -1);
            this.visualStyleMap.put("InCites", 1410511959);
            this.visualStyleMap.put("PubMed", -2113004178);
            this.visualStyleMap.put("Scopus", -2113004178);
        }
        return this.visualStyleMap.get(visualStyle);
    }

    public String[] getVisualStyleList(int visualStyleSelectorType) {
        String[] visualStyleList = null;
        switch (visualStyleSelectorType) {
            case -1: {
                visualStyleList = new String[]{"--SELECT NETWORK VISUAL STYLE--"};
                break;
            }
            case 1410511959: {
                visualStyleList = new String[]{"InCites"};
                break;
            }
            case -2113004178: {
                visualStyleList = new String[]{"PubMed"};
                break;
            }
            case -960949447: {
                visualStyleList = new String[]{"Scopus"};
            }
        }
        return visualStyleList;
    }
}

