/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.visualstyles;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.visualstyles.BasicSocialNetworkVisualstyle;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.presentation.property.values.NodeShape;

public class IncitesVisualStyle
extends BasicSocialNetworkVisualstyle {
    public static final String nodeattr_location = "Location";
    public static final String nodeattr_location_uoft = "UNIV TORONTO";
    public static final String nodeattr_location_canada = "Canada";
    public static final String nodeattr_location_us = "United States";
    public static final String nodeattr_location_ontario = "Ontario";
    public static final String nodeattr_location_inter = "International";
    public static final String nodeattr_location_other = "Other";
    public static final String nodeattr_location_na = "N/A";
    public static final String nodeattr_inst = "Institution";
    public static final String nodeattr_dept = "Department";
    public static final String networkattr_Faculty = "Total number of Faculty";
    public static final String networkattr_uniden_Faculty = "Total number of unidentified Faculty";
    public static final String networkattr_uniden_Faculty_list = "List of unidentified Faculty";
    private CyNetwork network;
    private SocialNetwork socialNetwork;

    private void applyIncitesNodeStyle() {
        CyTable nodeTable = null;
        int minNodeSize = 0;
        int maxNodeSize = 0;
        nodeTable = this.network.getDefaultNodeTable();
        CyColumn timesCitedColumn = nodeTable.getColumn("Times Cited");
        ArrayList timesCitedList = (ArrayList)timesCitedColumn.getValues(Integer.class);
        minNodeSize = this.getSmallestInCutoff(timesCitedList, 10.0);
        maxNodeSize = this.getLargestInCutoff(timesCitedList, 95.0);
        this.socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_SIZE, new Object[]{"Times Cited", minNodeSize + 1, maxNodeSize});
        HashMap colorAttrMap = new HashMap();
        HashMap<String, Color> locationsMap = new HashMap<String, Color>();
        locationsMap.put(nodeattr_location_ontario, new Color(255, 137, 41));
        locationsMap.put(nodeattr_location_canada, new Color(204, 0, 51));
        locationsMap.put(nodeattr_location_us, new Color(0, 51, 153));
        locationsMap.put(nodeattr_location_inter, new Color(0, 204, 204));
        locationsMap.put(nodeattr_location_other, new Color(204, 0, 204));
        locationsMap.put(nodeattr_location_uoft, new Color(0, 204, 0));
        locationsMap.put(nodeattr_location_na, new Color(153, 153, 153));
        colorAttrMap.put(nodeattr_location, locationsMap);
        this.socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_FILL_COLOR, new Object[]{colorAttrMap});
        HashMap shapeAttrMap = new HashMap();
        HashMap<String, NodeShape> departmentMap = new HashMap<String, NodeShape>();
        departmentMap.put((String)this.socialNetwork.getAttrMap().get(nodeattr_dept), NodeShapeVisualProperty.TRIANGLE);
        departmentMap.put(nodeattr_location_na, NodeShapeVisualProperty.RECTANGLE);
        shapeAttrMap.put(nodeattr_dept, departmentMap);
        this.socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_SHAPE, new Object[]{shapeAttrMap});
        HashMap borderpainAttrMap = new HashMap();
        HashMap<String, Color> departmentMap_borderpaint = new HashMap<String, Color>();
        departmentMap_borderpaint.put((String)this.socialNetwork.getAttrMap().get(nodeattr_dept), new Color(243, 243, 21));
        borderpainAttrMap.put(nodeattr_dept, departmentMap_borderpaint);
        this.socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_BORDER_PAINT, new Object[]{borderpainAttrMap});
        HashMap borderwidthAttrMap = new HashMap();
        HashMap<String, Double> departmentMap_borderwidth = new HashMap<String, Double>();
        departmentMap_borderwidth.put((String)this.socialNetwork.getAttrMap().get(nodeattr_dept), 10.0);
        borderwidthAttrMap.put(nodeattr_dept, departmentMap_borderwidth);
        this.socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_BORDER_WIDTH, new Object[]{borderwidthAttrMap});
        HashMap fontsizeAttrMap = new HashMap();
        HashMap<String, Font> departmentMap_fontsize = new HashMap<String, Font>();
        departmentMap_fontsize.put(nodeattr_location_uoft, new Font("Verdana", 1, 12));
        fontsizeAttrMap.put(nodeattr_location, departmentMap_fontsize);
        this.socialNetwork.getVisualStyleMap().put(BasicVisualLexicon.NODE_LABEL_FONT_FACE, new Object[]{fontsizeAttrMap});
    }

    public void applyVisualStyle(CyNetwork network, SocialNetwork socialNetwork) {
        this.network = network;
        this.socialNetwork = socialNetwork;
        this.applyNodeStyle(this.network, this.socialNetwork);
        this.applyIncitesNodeStyle();
        this.applyEdgeStyle(this.network, this.socialNetwork);
    }
}

