/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.pubmed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Tag;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EutilsTimesCitedParser
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(EutilsTimesCitedParser.class.getName());
    boolean isTimesCited = false;
    boolean isPMID = false;
    private ArrayList<Publication> pubList = new ArrayList();
    private StringBuilder pmid = null;
    private StringBuilder timesCited = null;
    private int index = 0;

    public EutilsTimesCitedParser(ArrayList<Publication> pubList, String queryKey, String webEnv, int retStart, int retMax) {
        try {
            this.pubList = pubList;
            int totalPubs = pubList.size();
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String url = null;
            while (retStart < totalPubs) {
                Tag tag = new Tag(queryKey, webEnv, retStart, retMax);
                url = String.format("http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=pubmed%s", tag);
                saxParser.parse(url, (DefaultHandler)this);
                retStart += retMax;
            }
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Encountered temporary server issues. Please try again some other time.");
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            CytoscapeUtilities.notifyUser("Unable to connect to PubMed. Please check your internet connection.");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isPMID) {
            this.pmid.append(ch, start, length);
            this.isPMID = false;
        }
        if (this.isTimesCited) {
            this.timesCited.append(ch, start, length);
            this.isTimesCited = false;
        }
    }

    public boolean contains(Attributes attributes, String text) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getValue(i).equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("DocSum")) {
            Publication pub = this.pubList.get(this.index);
            pub.setTimesCited(this.timesCited.toString());
            ++this.index;
            if (!pub.getPMID().equals(this.pmid.toString())) {
                logger.log(Level.WARNING, "SAX parser truncated pmid from " + pub.getPMID() + " to " + this.pmid.toString());
            }
            this.pmid = null;
            this.timesCited = null;
        }
    }

    public ArrayList<Publication> getPubList() {
        return this.pubList;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.contains(attributes, "PmcRefCount")) {
            this.isTimesCited = true;
            this.timesCited = new StringBuilder();
        }
        if (qName.equals("Id")) {
            this.isPMID = true;
            this.pmid = new StringBuilder();
        }
    }
}

