/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import org.cytoscape.work.TaskMonitor;

public class MonitoredFileInputStream
extends FileInputStream {
    private int currentSteps = 0;
    private int totalSteps = 0;
    private double progress = 0.0;
    private TaskMonitor taskMonitor = null;

    public MonitoredFileInputStream(File file, TaskMonitor taskMonitor, String message) throws FileNotFoundException, IOException {
        super(file);
        this.taskMonitor = taskMonitor;
        this.setProgressMonitor(message, this.available());
    }

    public int read() throws IOException {
        return super.read();
    }

    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    private void setProgressMonitor(String taskName, int totalSteps) {
        this.taskMonitor.setTitle(taskName);
        this.taskMonitor.setProgress(0.0);
        this.currentSteps = 0;
        this.totalSteps = totalSteps;
    }

    private String toPercent(double progress) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(progress *= 100.0) + "%";
    }

    private void updateProgress() {
        ++this.currentSteps;
        this.progress = (double)this.currentSteps / (double)this.totalSteps;
        this.taskMonitor.setStatusMessage("Complete: " + this.toPercent(this.progress));
        this.taskMonitor.setProgress(this.progress);
    }
}

