/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scopus {
    private static final Logger logger = Logger.getLogger(Scopus.class.getName());
    private int currentSteps = 0;
    private int totalSteps = 0;
    private double progress = 0.0;
    private TaskMonitor taskMonitor = null;
    private ArrayList<Publication> pubList = null;

    public static HashMap<String, Object> constructScopusAttrMap(Author author) {
        HashMap<String, Object> nodeAttrMap = new HashMap<String, Object>();
        String[] columns = new String[]{"Label", "Last Name", "First Name", "Times Cited", "# of Publications", "Publications"};
        int i = 0;
        for (i = 0; i < 4; ++i) {
            nodeAttrMap.put(columns[i], "");
        }
        nodeAttrMap.put(columns[i], 0);
        nodeAttrMap.put(columns[i + 1], new ArrayList());
        return nodeAttrMap;
    }

    public Scopus(File csv, TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
        this.parseScopusPubList(csv);
    }

    public ArrayList<Publication> getPubList() {
        if (this.pubList == null) {
            this.pubList = new ArrayList();
        }
        return this.pubList;
    }

    private boolean matchYear(String rawText) {
        Pattern pattern = Pattern.compile("^\\d{4}$");
        Matcher matcher = pattern.matcher(rawText.trim());
        return matcher.find();
    }

    private ArrayList<Author> parseAuthors(String authors) {
        String[] contents;
        ArrayList<Author> authorList = new ArrayList<Author>();
        for (String authorInfo : contents = authors.split("\\.,")) {
            authorList.add(new Author(authorInfo.trim(), -960949447));
        }
        return authorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseScopusPubList(File csv) {
        Scanner in = null;
        try {
            this.setProgressMonitor("Parsing Scopus CSV ...", this.totalSteps);
            in = new Scanner(csv);
            String line = null;
            String authors = null;
            String year = null;
            String[] columns = null;
            Publication pub = null;
            ArrayList<Author> coauthorList = new ArrayList();
            String title = null;
            String subjectArea = null;
            String timesCited = null;
            String numericalData = null;
            while (in.hasNext()) {
                line = in.nextLine();
                columns = this.splitQuoted("\"", ",", line);
                authors = columns[0].replace("\"", "");
                coauthorList = this.parseAuthors(authors);
                title = columns[1].replace("\"", "");
                year = columns[2].replace("\"", "");
                if (!this.matchYear(year)) {
                    logger.log(Level.WARNING, "Unable to parse scopus line: " + line.toString());
                    continue;
                }
                subjectArea = columns[3].replace("\"", "");
                numericalData = columns[10] != null ? columns[10].replace("\"", "") : columns[10];
                timesCited = numericalData == null || numericalData.equalsIgnoreCase("") ? "0" : numericalData;
                pub = new Publication(title, year, subjectArea, timesCited, null, coauthorList);
                this.getPubList().add(pub);
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Exception occurred", e);
            this.taskMonitor.setStatusMessage("File not found");
            CytoscapeUtilities.notifyUser("Unable to locate Scopus data file.\nPlease re-load file and try again.");
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void setPubList(ArrayList<Publication> pubList) {
        this.pubList = pubList;
    }

    private String[] splitQuoted(String quote, String separator, String s) {
        String[] columns = new String[14];
        int current = 0;
        int index = 0;
        int startindex = 0;
        int firstquote = s.indexOf(quote);
        int nextquote = s.indexOf(quote, current + 1);
        int nextcomma = s.indexOf(separator);
        while (current < s.length() && index < 14) {
            if (nextcomma > current && (nextcomma < firstquote || nextcomma > nextquote)) {
                columns[index] = s.substring(startindex, nextcomma);
                startindex = nextcomma + 1;
                ++index;
            }
            int n = nextcomma = (nextcomma = s.indexOf(separator, (current = nextcomma) + 1)) == -1 ? s.length() : nextcomma;
            if (current <= nextquote) continue;
            firstquote = s.indexOf(quote, nextquote + 1);
            nextquote = s.indexOf(quote, firstquote + 1);
        }
        return columns;
    }

    private void setProgressMonitor(String taskName, int totalSteps) {
        this.taskMonitor.setTitle(taskName);
        this.taskMonitor.setProgress(0.0);
        this.currentSteps = 0;
        this.totalSteps = totalSteps;
    }

    private String toPercent(double progress) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(progress *= 100.0) + "%";
    }

    private void updateProgress() {
        ++this.currentSteps;
        this.progress = (double)this.currentSteps / (double)this.totalSteps;
        this.taskMonitor.setStatusMessage("Complete: " + this.toPercent(this.progress));
        this.taskMonitor.setProgress(this.progress);
    }

    public static class UnableToParseYearException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

