/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.cytoscape.model.CyEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Publication
extends AbstractEdge {
    private ArrayList<Author> authorList = new ArrayList();
    private String expectedCitations = null;
    private String journal = null;
    private String location = "N/A";
    private String pubDate = null;
    private String timesCited = null;
    private String title = null;
    private String pmid = null;

    public Publication(String title, String pubDate, String journal, String timesCited, String expectedCitations, List<Author> coauthorList) {
        this.pubDate = pubDate;
        this.title = title;
        this.journal = journal;
        this.authorList.addAll(coauthorList);
        if (timesCited != null && Pattern.matches("[0-9]+", timesCited)) {
            this.timesCited = timesCited;
        }
        this.expectedCitations = expectedCitations;
        this.constructEdgeAttrMap();
        this.calculateLocation();
    }

    public void calculateLocation() {
        String maxlocation = "N/A";
        Integer max = 0;
        HashMap<String, Integer> all_locations = new HashMap<String, Integer>();
        for (Author author : this.authorList) {
            String current_location = author.getLocation();
            if (all_locations.containsKey(current_location)) {
                Integer count = (Integer)all_locations.get(current_location) + 1;
                all_locations.put(current_location, count);
                if (count <= max || current_location.equalsIgnoreCase("N/A")) continue;
                max = count;
                maxlocation = current_location;
                continue;
            }
            all_locations.put(current_location, 1);
        }
        this.location = maxlocation;
    }

    @Override
    public void constructEdgeAttrMap() {
        this.edgeAttrMap = new HashMap();
        this.edgeAttrMap.put("Times Cited", this.timesCited);
        this.edgeAttrMap.put("Pub Date", this.pubDate);
        this.edgeAttrMap.put("Journal", this.journal);
        this.edgeAttrMap.put("Title", this.title);
    }

    public ArrayList<Author> getAuthorList() {
        return this.authorList;
    }

    public String getAuthors() {
        String allAuthors = "";
        for (Author author : this.authorList) {
            allAuthors = allAuthors + author + ", ";
        }
        return allAuthors;
    }

    @Override
    public CyEdge getCyEdge() {
        return this.cyEdge;
    }

    @Override
    public Map<String, Object> getEdgeAttrMap() {
        return this.edgeAttrMap;
    }

    public String getExpectedCitations() {
        return this.expectedCitations;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public List<? extends AbstractNode> getNodes() {
        return this.authorList;
    }

    public String getPMID() {
        return this.pmid;
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public int getTimesCited() {
        if (this.timesCited != null && Pattern.matches("[0-9]+", this.timesCited)) {
            return Integer.parseInt(this.timesCited);
        }
        return 0;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isSingleAuthored() {
        return this.authorList.size() == 2 && this.authorList.get(0).equals(this.authorList.get(1));
    }

    public void setAuthorList(ArrayList<Author> authorList) {
        this.authorList = authorList;
    }

    public void setAuthors(ArrayList<Author> authors) {
        this.authorList = authors;
    }

    @Override
    public void setCyEdge(CyEdge cyEdge) {
        this.cyEdge = cyEdge;
    }

    public void setExpectedCitations(String expectedCitations) {
        this.expectedCitations = expectedCitations;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPMID(String pmid) {
        this.pmid = pmid;
    }

    public void setPubDate(String date) {
        this.pubDate = date;
    }

    public void setTimesCited(int timesCited) {
        this.timesCited = String.valueOf(timesCited);
    }

    public void setTimesCited(String timesCited) {
        this.timesCited = timesCited;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return "Title: " + this.title + "\nTimes Cited: " + this.timesCited;
    }
}

