/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.baderlab.csapps.socialnetwork.actions.ShowUserPanelAction;
import org.baderlab.csapps.socialnetwork.model.Category;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;

public class RestoreNetworksFromProp
implements SessionLoadedListener {
    private SocialNetworkAppManager appManager = null;
    private CyServiceRegistrar cyServiceRegistrar = null;
    private CytoPanel cytoPanelWest = null;
    private ShowUserPanelAction userPanelAction = null;
    private CyNetworkViewManager viewManager = null;
    private UserPanel userPanel = null;

    public RestoreNetworksFromProp(SocialNetworkAppManager appManager, CyNetworkViewManager viewManager, CyServiceRegistrar cyServiceRegistrar, CySwingApplication cySwingApplicationService, ShowUserPanelAction userPanelAction, UserPanel userPanel) {
        this.appManager = appManager;
        this.viewManager = viewManager;
        this.cyServiceRegistrar = cyServiceRegistrar;
        this.cytoPanelWest = cySwingApplicationService.getCytoPanel(CytoPanelName.WEST);
        this.userPanelAction = userPanelAction;
        this.userPanel = userPanel;
    }

    public void handleEvent(SessionLoadedEvent e) {
        if (e.getLoadedSession().getAppFileListMap() == null || e.getLoadedSession().getAppFileListMap().size() == 0) {
            return;
        }
        List files = (List)e.getLoadedSession().getAppFileListMap().get("socialnetwork");
        if (files == null || files.size() == 0) {
            return;
        }
        String currentName = (String)this.userPanelAction.getValue("Name");
        if (currentName.trim().equalsIgnoreCase("Show Social Network")) {
            int index;
            this.cyServiceRegistrar.registerService((Object)this.userPanel, CytoPanelComponent.class, new Properties());
            if (this.cytoPanelWest.getState() == CytoPanelState.HIDE) {
                this.cytoPanelWest.setState(CytoPanelState.DOCK);
            }
            if ((index = this.cytoPanelWest.indexOfComponent((Component)this.userPanel)) == -1) {
                return;
            }
            this.cytoPanelWest.setSelectedIndex(index);
            this.userPanelAction.putValue("Name", "Hide Social Network");
        }
        try {
            File propFile = (File)files.get(0);
            BufferedReader in = new BufferedReader(new FileReader(propFile));
            in.readLine();
            String line = in.readLine();
            String[] networkData = null;
            ArrayList<String> listOfSocialNetworks = new ArrayList<String>();
            ArrayList<String> listOfTypes = new ArrayList<String>();
            ArrayList<String> listOfNumPubs = new ArrayList<String>();
            ArrayList<String> listOfNumFaculty = new ArrayList<String>();
            ArrayList<String> listOfNumUnidenFaculty = new ArrayList<String>();
            while (line != null) {
                networkData = line.split(",");
                listOfSocialNetworks.add(networkData[0]);
                listOfTypes.add(networkData[1]);
                listOfNumPubs.add(networkData[2]);
                listOfNumFaculty.add(networkData[3]);
                listOfNumUnidenFaculty.add(networkData[4]);
                line = in.readLine();
            }
            SocialNetwork socialNetwork = null;
            CyNetworkView networkView = null;
            Collection views = null;
            int index = -1;
            for (CyNetwork n : e.getLoadedSession().getNetworks()) {
                index = listOfSocialNetworks.indexOf(n.toString());
                if (index <= -1) continue;
                socialNetwork = new SocialNetwork(n.toString(), Category.toCategory((String)listOfTypes.get(index)));
                socialNetwork.setCyNetwork(n);
                socialNetwork.setNum_publications(Integer.valueOf((String)listOfNumPubs.get(index)));
                socialNetwork.setNum_faculty(Integer.valueOf((String)listOfNumFaculty.get(index)));
                socialNetwork.setNum_uniden_faculty(Integer.valueOf((String)listOfNumUnidenFaculty.get(index)));
                views = this.viewManager.getNetworkViews(n);
                if (views.size() != 0) {
                    networkView = (CyNetworkView)views.iterator().next();
                }
                socialNetwork.setNetworkView(networkView);
                this.appManager.getSocialNetworkMap().put(n.toString(), socialNetwork);
                this.appManager.getUserPanelRef().addNetworkToNetworkPanel(socialNetwork);
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

