/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.awt.Cursor;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.actions.ShowUserPanelAction;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.Interaction;
import org.baderlab.csapps.socialnetwork.model.Search;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.visualstyles.VisualStyles;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.baderlab.csapps.socialnetwork.tasks.ApplyVisualStyleTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.CreateNetworkTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.DestroyNetworkTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ParseIncitesXLSXTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ParsePubMedXMLTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ParseScopusCSVTaskFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialNetworkAppManager {
    private static ApplyVisualStyleTaskFactory applyVisualStyleTaskFactoryRef = null;
    private SocialNetwork currentlySelectedSocialNetwork = null;
    private CyApplicationManager cyAppManagerServiceRef = null;
    private CyServiceRegistrar cyServiceRegistrarRef = null;
    private DestroyNetworkTaskFactory destroyNetworkTaskFactoryRef = null;
    private Map<Collaboration, ArrayList<AbstractEdge>> map = null;
    private String networkName = null;
    private CreateNetworkTaskFactory networkTaskFactoryRef = null;
    private ParseIncitesXLSXTaskFactory parseIncitesXLSXTaskFactoryRef = null;
    private ParsePubMedXMLTaskFactory parsePubMedXMLTaskFactoryRef = null;
    private ParseScopusCSVTaskFactory parseScopusCSVTaskFactoryRef = null;
    private CyNetwork networkToBeDestroyed = null;
    private Map<String, SocialNetwork> socialNetworkMap = null;
    private TaskManager<?, ?> taskManagerServiceRef = null;
    private ShowUserPanelAction userPanelAction = null;
    private UserPanel userPanelRef = null;
    private int visualStyleID = -1;
    private File networkFile = null;
    private int maxAuthorThreshold = -1;
    private int networkFileType = -1;
    private HashSet<String> visualStyleSet = null;
    public static final int ANALYSISTYPE_INCITES = 1410511959;
    public static final int ANALYSISTYPE_SCOPUS = -960949447;
    public static final int ANALYSISTYPE_PUBMED = -2113004178;
    private int analysis_type = 1410511959;

    public static ApplyVisualStyleTaskFactory getApplyVisualStyleTaskFactoryRef() {
        return applyVisualStyleTaskFactoryRef;
    }

    public static String getNetworkName(CyNetwork network) {
        ArrayList rowList = (ArrayList)network.getDefaultNetworkTable().getAllRows();
        CyRow row = (CyRow)rowList.get(0);
        String networkName = (String)row.getAllValues().get("name");
        return networkName;
    }

    public void applyVisualStyle(String visualStyle) {
        this.setVisualStyleID(new VisualStyles().getVisualStyleID(visualStyle));
        this.getTaskManager().execute(this.getApplyVisualStyleTaskFactoryRef().createTaskIterator());
    }

    public void closeUserPanel() {
        this.getServiceRegistrar().unregisterService((Object)this.getUserPanelRef(), CytoPanelComponent.class);
        this.getUserPanelAction().putValue("Name", "Show Social Network");
    }

    private void createNetwork() {
        this.getTaskManager().execute(this.getNetworkTaskFactoryRef().createTaskIterator());
    }

    public void createNetwork(File networkFile, int maxAuthorThreshold) throws FileNotFoundException {
        String networkName = this.userPanelRef.getAcademiaPanel().getFacultyTextFieldRef().getText().trim();
        if (!this.isNameValid(networkName).booleanValue()) {
            CytoscapeUtilities.notifyUser("Network " + networkName + " already exists in Cytoscape." + " Please enter a new name.");
            return;
        }
        this.getUserPanelRef().setCursor(new Cursor(3));
        String extension = FilenameUtils.getExtension((String)networkFile.getPath()).trim();
        this.setNetworkFile(networkFile);
        this.setNetworkName(networkName);
        this.setMaxAuthorThreshold(maxAuthorThreshold);
        if (this.analysis_type == 1410511959) {
            if (!extension.equalsIgnoreCase("xlsx")) {
                this.getUserPanelRef().setCursor(new Cursor(0));
                CytoscapeUtilities.notifyUser("Invalid file. InCites data files either have to be excel spreadsheets or text files.");
                return;
            }
            this.visualizeIncitesXLSX();
        } else if (this.analysis_type == -2113004178) {
            if (!extension.equalsIgnoreCase("xml")) {
                this.getUserPanelRef().setCursor(new Cursor(0));
                CytoscapeUtilities.notifyUser("Invalid file. PubMed data files have to be in xml format.");
                return;
            }
            this.visualizePubMedXML();
        } else if (this.analysis_type == -960949447) {
            if (!extension.equalsIgnoreCase("csv")) {
                this.getUserPanelRef().setCursor(new Cursor(0));
                CytoscapeUtilities.notifyUser("Invalid file. Scopus data files have to be csv spreadsheets");
                return;
            }
            this.visualizeScopusCSV();
        }
    }

    public void createNetwork(String searchTerm, int category, int maxAuthorThreshold) {
        if (!this.isNameValid(searchTerm).booleanValue()) {
            CytoscapeUtilities.notifyUser("Network " + this.networkName + " already exists in Cytoscape." + " Please enter a new name.");
            return;
        }
        Search search = new Search(searchTerm, category, this);
        List<? extends AbstractEdge> results = search.getResults();
        if (results == null) {
            this.getUserPanelRef().setCursor(new Cursor(0));
            CytoscapeUtilities.notifyUser("Network could not be loaded");
            return;
        }
        if (results.size() == 0) {
            this.getUserPanelRef().setCursor(new Cursor(0));
            CytoscapeUtilities.notifyUser("Search did not yield any results");
            return;
        }
        Map<Collaboration, ArrayList<AbstractEdge>> map = null;
        Interaction interaction = null;
        SocialNetwork socialNetwork = null;
        switch (category) {
            case 1249763952: {
                category = -2113004178;
                interaction = new Interaction(results, category, maxAuthorThreshold);
                if (interaction.getExcludedPublications().size() == results.size()) {
                    this.getUserPanelRef().setCursor(new Cursor(0));
                    CytoscapeUtilities.notifyUser("Network couldn't be loaded. Adjust max author threshold.");
                    return;
                }
                socialNetwork = new SocialNetwork(searchTerm, category);
                ArrayList pubList = (ArrayList)results;
                socialNetwork.setPublications(pubList);
                socialNetwork.setExcludedPubs(interaction.getExcludedPublications());
                map = interaction.getAbstractMap();
                this.setNetworkName(searchTerm);
                this.getSocialNetworkMap().put(searchTerm, socialNetwork);
                this.setMap(map);
                this.createNetwork();
            }
        }
    }

    public void destroyNetwork(CyNetwork network) {
        this.setNetworkToBeDestroyed(network);
        this.getTaskManager().execute(this.getDestroyNetworkTaskFactoryRef().createTaskIterator());
    }

    public int getAnalysis_type() {
        return this.analysis_type;
    }

    public SocialNetwork getCurrentlySelectedSocialNetwork() {
        return this.currentlySelectedSocialNetwork;
    }

    public CyApplicationManager getCyAppManagerServiceRef() {
        return this.cyAppManagerServiceRef;
    }

    public DestroyNetworkTaskFactory getDestroyNetworkTaskFactoryRef() {
        return this.destroyNetworkTaskFactoryRef;
    }

    public Map<Collaboration, ArrayList<AbstractEdge>> getMap() {
        return this.map;
    }

    public int getMaxAuthorThreshold() {
        return this.maxAuthorThreshold;
    }

    public File getNetworkFile() {
        return this.networkFile;
    }

    public int getNetworkFileType() {
        return this.networkFileType;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public String[] getNetworkTableColumnNames() {
        return new String[]{"Name", "Node Count", "Edge Count", "Category"};
    }

    public CreateNetworkTaskFactory getNetworkTaskFactoryRef() {
        return this.networkTaskFactoryRef;
    }

    public CyNetwork getNetworkToBeDestroyed() {
        return this.networkToBeDestroyed;
    }

    public ParseIncitesXLSXTaskFactory getParseIncitesXLSXTaskFactoryRef() {
        return this.parseIncitesXLSXTaskFactoryRef;
    }

    public ParsePubMedXMLTaskFactory getParsePubMedXMLTaskFactoryRef() {
        return this.parsePubMedXMLTaskFactoryRef;
    }

    public ParseScopusCSVTaskFactory getParseScopusCSVTaskFactoryRef() {
        return this.parseScopusCSVTaskFactoryRef;
    }

    public CyServiceRegistrar getServiceRegistrar() {
        return this.cyServiceRegistrarRef;
    }

    public SocialNetwork getSocialNetwork(String name) {
        if (this.socialNetworkMap != null && this.socialNetworkMap.containsKey(name)) {
            return this.socialNetworkMap.get(name);
        }
        return null;
    }

    public Map<String, SocialNetwork> getSocialNetworkMap() {
        if (this.socialNetworkMap == null) {
            this.setSocialNetworkMap(new HashMap<String, SocialNetwork>());
            this.socialNetworkMap.put("DEFAULT", new SocialNetwork("DEFAULT", -1));
        }
        return this.socialNetworkMap;
    }

    public TaskManager<?, ?> getTaskManager() {
        return this.taskManagerServiceRef;
    }

    public ShowUserPanelAction getUserPanelAction() {
        return this.userPanelAction;
    }

    public UserPanel getUserPanelRef() {
        return this.userPanelRef;
    }

    public int getVisualStyleID() {
        return this.visualStyleID;
    }

    public Boolean isNameValid(String name) {
        return !this.getSocialNetworkMap().containsKey(name);
    }

    public boolean isValidVisualStyle(String visualStyleName) {
        if (this.visualStyleSet == null) {
            this.visualStyleSet = new HashSet();
            this.visualStyleSet.add("Scopus");
            this.visualStyleSet.add("PubMed");
            this.visualStyleSet.add("InCites");
        }
        return this.visualStyleSet.contains(visualStyleName);
    }

    public void setAnalysis_type(int analysis_type) {
        this.analysis_type = analysis_type;
    }

    public void setApplyVisualStyleTaskFactoryRef(ApplyVisualStyleTaskFactory applyViewTaskFactoryRef) {
        applyVisualStyleTaskFactoryRef = applyViewTaskFactoryRef;
    }

    public void setCurrentlySelectedSocialNetwork(SocialNetwork currentlySelectedSocialNetwork) {
        this.currentlySelectedSocialNetwork = currentlySelectedSocialNetwork;
    }

    public void setCurrentNetworkView(String networkName) {
        CyNetworkView networkView = this.getSocialNetworkMap().get(networkName).getNetworkView();
        this.getCyAppManagerServiceRef().setCurrentNetworkView(networkView);
    }

    public void setCyAppManagerServiceRef(CyApplicationManager cyAppManagerServiceRef) {
        this.cyAppManagerServiceRef = cyAppManagerServiceRef;
    }

    public void setDestroyNetworkTaskFactoryRef(DestroyNetworkTaskFactory destroyNetworkTaskFactory) {
        this.destroyNetworkTaskFactoryRef = destroyNetworkTaskFactory;
    }

    public void setMap(Map<Collaboration, ArrayList<AbstractEdge>> map) {
        this.map = map;
    }

    private void setMaxAuthorThreshold(int maxAuthorThreshold) {
        this.maxAuthorThreshold = maxAuthorThreshold;
    }

    public void setNetworkFile(File networkFile) {
        this.networkFile = networkFile;
    }

    public void setNetworkFileType(int networkFileType) {
        this.networkFileType = networkFileType;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public void setNetworkTaskFactoryRef(CreateNetworkTaskFactory networkTaskFactoryRef) {
        this.networkTaskFactoryRef = networkTaskFactoryRef;
    }

    public void setNetworkToBeDestroyed(CyNetwork networkToBeDestroyed) {
        this.networkToBeDestroyed = networkToBeDestroyed;
    }

    public void setParseIncitesXLSXTaskFactoryRef(ParseIncitesXLSXTaskFactory parseIncitesXLSXTaskFactoryRef) {
        this.parseIncitesXLSXTaskFactoryRef = parseIncitesXLSXTaskFactoryRef;
    }

    public void setParsePubMedXMLTaskFactoryRef(ParsePubMedXMLTaskFactory parsePubMedXMLTaskFactoryRef) {
        this.parsePubMedXMLTaskFactoryRef = parsePubMedXMLTaskFactoryRef;
    }

    public void setParseScopusCSVTaskFactoryRef(ParseScopusCSVTaskFactory parseScopusCSVTaskFactoryRef) {
        this.parseScopusCSVTaskFactoryRef = parseScopusCSVTaskFactoryRef;
    }

    public void setServiceRegistrar(CyServiceRegistrar cyServiceRegistrarRef) {
        this.cyServiceRegistrarRef = cyServiceRegistrarRef;
    }

    public void setSocialNetworkMap(Map<String, SocialNetwork> socialNetwork) {
        this.socialNetworkMap = socialNetwork;
    }

    public void setTaskManager(TaskManager<?, ?> taskManager) {
        this.taskManagerServiceRef = taskManager;
    }

    public void setUserPanelAction(ShowUserPanelAction userPanelAction) {
        this.userPanelAction = userPanelAction;
    }

    public void setUserPanelRef(UserPanel userPanelRef) {
        this.userPanelRef = userPanelRef;
    }

    public void setVisualStyleID(int visualStyleID) {
        this.visualStyleID = visualStyleID;
    }

    private void visualizeIncitesXLSX() {
        this.getTaskManager().execute(this.getParseIncitesXLSXTaskFactoryRef().createTaskIterator());
    }

    private void visualizePubMedXML() {
        this.getTaskManager().execute(this.getParsePubMedXMLTaskFactoryRef().createTaskIterator());
    }

    private void visualizeScopusCSV() {
        this.getTaskManager().execute(this.getParseScopusCSVTaskFactoryRef().createTaskIterator());
    }
}

