/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialNetwork {
    private CyNetworkView cyNetworkViewRef = null;
    private String networkName = "";
    private CyNetwork cyNetwork = null;
    private int networkType = -1;
    private Map<Object, Object[]> visualStyleMap = null;
    private int defaultVisualStyle = -1;
    private Map<String, Object> attrMap = null;
    private ArrayList<Publication> publications = null;
    private ArrayList<Publication> excludedPubs = null;
    private ArrayList<Author> identifiedFaculty = null;
    private ArrayList<Author> unidentifiedFaculty = null;
    private HashSet<Author> faculty = null;
    private String networkSummary = null;
    private HashMap<String, Integer> locations_totalpubsummary = null;
    private HashMap<String, Integer> locations_totalcitsummary = null;
    private int num_publications = 0;
    private int num_faculty = 0;
    private int num_uniden_faculty = 0;
    private String unidentified_faculty = "";

    public SocialNetwork(String networkName, int networkType) {
        this.setNetworkName(networkName);
        this.setNetworkType(networkType);
        switch (networkType) {
            case 1410511959: {
                this.setDefaultVisualStyle(1410511959);
                break;
            }
            case -960949447: {
                this.setDefaultVisualStyle(-960949447);
                break;
            }
            case -2113004178: {
                this.setDefaultVisualStyle(-2113004178);
            }
        }
    }

    public Map<String, Object> getAttrMap() {
        if (this.attrMap == null) {
            this.setAttrMap(new HashMap<String, Object>());
        }
        return this.attrMap;
    }

    public CyNetwork getCyNetwork() {
        return this.cyNetwork;
    }

    public int getDefaultVisualStyle() {
        return this.defaultVisualStyle;
    }

    public ArrayList<Publication> getExcludedPubs() {
        if (this.excludedPubs == null) {
            this.excludedPubs = new ArrayList();
        }
        return this.excludedPubs;
    }

    public HashSet<Author> getFaculty() {
        return this.faculty;
    }

    public ArrayList<Author> getIdentifiedFaculty() {
        return this.identifiedFaculty;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public String getNetworkSummary() {
        String info = "<html>";
        switch (this.networkType) {
            case 1410511959: {
                info = info + "Total # of publications: " + this.num_publications + "<br>" + "Total # of faculty: " + this.num_faculty + "<br<Total # of unidentified faculty: " + this.num_uniden_faculty;
                if (this.num_uniden_faculty > 0) {
                    info = info + "<hr><br>Unidentified Faculty (see below)<br>" + this.unidentified_faculty;
                }
                if (this.getExcludedPubs().size() <= 0) break;
                info = info + "Total # of excluded publications: " + this.getExcludedPubs().size();
                break;
            }
            default: {
                info = "<html>Total # of publications: " + this.num_publications;
                if (this.getExcludedPubs().size() <= 0) break;
                info = info + "<br>Total # of excluded publications: " + this.getExcludedPubs().size();
            }
        }
        this.networkSummary = info + "</html>";
        return this.networkSummary;
    }

    public int getNetworkType() {
        return this.networkType;
    }

    public CyNetworkView getNetworkView() {
        return this.cyNetworkViewRef;
    }

    public int getNum_faculty() {
        return this.num_faculty;
    }

    public int getNum_publications() {
        return this.num_publications;
    }

    public int getNum_uniden_faculty() {
        return this.num_uniden_faculty;
    }

    public ArrayList<Publication> getPublications() {
        return this.publications;
    }

    private String getSummaryOfExcludedPubs() {
        String summary = "<table border=\"1\">";
        summary = summary + "<td><b>Publication</b></td><td><b># of authors</b></td><td><b>Times Cited</b></td>";
        Publication pub = null;
        for (AbstractEdge abstractEdge : this.getExcludedPubs()) {
            pub = (Publication)abstractEdge;
            summary = summary + "<tr>";
            summary = summary + "<td>" + pub.getTitle() + "</td>";
            summary = summary + "<td>" + pub.getAuthorList().size() + "</td>";
            summary = summary + "<td>" + pub.getTimesCited() + "</td>";
            summary = summary + "</tr";
        }
        summary = summary + "</table>";
        return summary;
    }

    public String getUnidentified_faculty() {
        return this.unidentified_faculty;
    }

    public ArrayList<Author> getUnidentifiedFaculty() {
        return this.unidentifiedFaculty;
    }

    public Map<Object, Object[]> getVisualStyleMap() {
        if (this.visualStyleMap == null) {
            this.setVisualStyleMap(new HashMap<Object, Object[]>());
        }
        return this.visualStyleMap;
    }

    public void setAttrMap(Map<String, Object> attrMap) {
        this.attrMap = attrMap;
    }

    public void setCyNetwork(CyNetwork cyNetwork) {
        this.cyNetwork = cyNetwork;
    }

    public void setDefaultVisualStyle(int defaultVisualStyle) {
        this.defaultVisualStyle = defaultVisualStyle;
    }

    public void setExcludedPubs(ArrayList<Publication> excludedPubs) {
        this.excludedPubs = excludedPubs;
    }

    public void setFaculty(HashSet<Author> faculty) {
        this.faculty = faculty;
        this.setNum_faculty(faculty.size());
    }

    public void setIdentifiedFaculty(ArrayList<Author> identifiedFaculty) {
        this.identifiedFaculty = identifiedFaculty;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public void setNetworkType(int networkType) {
        this.networkType = networkType;
    }

    public void setNetworkView(CyNetworkView cyNetworkViewRef) {
        this.cyNetworkViewRef = cyNetworkViewRef;
    }

    public void setNum_faculty(int num_faculty) {
        this.num_faculty = num_faculty;
    }

    public void setNum_publications(int num_publications) {
        this.num_publications = num_publications;
    }

    public void setNum_uniden_faculty(int num_uniden_faculty) {
        this.num_uniden_faculty = num_uniden_faculty;
    }

    public void setPublications(ArrayList<Publication> publications) {
        this.publications = publications;
        this.setNum_publications(publications.size());
        if (this.networkType == 1410511959) {
            this.locations_totalcitsummary = this.summarize_totalCitations();
            this.locations_totalpubsummary = this.summarize_totalPublications();
        }
    }

    public void setSummary(String summary) {
        this.networkSummary = summary;
    }

    public void setUnidentified_faculty(String unidentified_faculty) {
        this.unidentified_faculty = unidentified_faculty;
    }

    public void setUnidentifiedFaculty(ArrayList<Author> unidentifiedFaculty) {
        this.unidentifiedFaculty = unidentifiedFaculty;
        this.setNum_uniden_faculty(unidentifiedFaculty.size());
    }

    public void setVisualStyleMap(Map<Object, Object[]> visualStyleMap) {
        this.visualStyleMap = visualStyleMap;
    }

    private HashMap<String, Integer> summarize_totalCitations() {
        HashMap<String, Integer> locations_summary = new HashMap<String, Integer>();
        if (this.publications != null) {
            for (Publication pub : this.publications) {
                String current_location = pub.getLocation();
                if (locations_summary.containsKey(current_location)) {
                    Integer count = locations_summary.get(current_location) + pub.getTimesCited();
                    locations_summary.put(current_location, count);
                    continue;
                }
                locations_summary.put(current_location, pub.getTimesCited());
            }
        }
        return locations_summary;
    }

    private HashMap<String, Integer> summarize_totalPublications() {
        HashMap<String, Integer> locations_summary = new HashMap<String, Integer>();
        if (this.publications != null) {
            for (Publication pub : this.publications) {
                String current_location = pub.getLocation();
                if (locations_summary.containsKey(current_location)) {
                    Integer count = locations_summary.get(current_location) + 1;
                    locations_summary.put(current_location, count);
                    continue;
                }
                locations_summary.put(current_location, 1);
            }
        }
        return locations_summary;
    }
}

