/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkViewManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportNeighborsAction
extends AbstractCyAction {
    private static final Logger logger = Logger.getLogger(ExportNeighborsAction.class.getName());
    private CyNetworkManager cyNetworkManagerServiceRef = null;
    private CySwingApplication cySwingApplicationServiceRef = null;
    private JPanel exportNeighborsPanelRef = null;
    private JTextField neighborDegreeRef = null;
    private JComboBox<String> nodeAttrComboBoxRef = null;
    private JComboBox<String> networkNameComboBoxRef = null;
    private HashMap<String, CyNetwork> cyNetworkMap = null;

    public ExportNeighborsAction(Map<String, String> configProps, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager, CyNetworkManager cyNetworkManagerServiceRef, CySwingApplication cySwingApplicationServiceRef) {
        super(configProps, applicationManager, networkViewManager);
        this.putValue("Name", "Export Neighbors");
        this.cyNetworkManagerServiceRef = cyNetworkManagerServiceRef;
        this.cySwingApplicationServiceRef = cySwingApplicationServiceRef;
        this.nodeAttrComboBoxRef = new JComboBox();
        this.cyNetworkMap = new HashMap();
        this.networkNameComboBoxRef = this.createNetworkNameComboBoxRef();
    }

    public void actionPerformed(ActionEvent e) {
        int outcome = 0;
        while (outcome == 0) {
            this.updateNetworkNameComboBoxRef();
            outcome = JOptionPane.showConfirmDialog(null, this.getExportNeighborsPanelRef(), "Export neighbor list options", 2);
            if (outcome != 0) continue;
            String networkName = (String)this.networkNameComboBoxRef.getSelectedItem();
            CyNetwork network = this.cyNetworkMap.get(networkName);
            if (network == null) {
                CytoscapeUtilities.notifyUser("Unable to export. No network is available");
                return;
            }
            String text = this.neighborDegreeRef.getText().trim();
            if (!Pattern.matches("[0-9]+", text)) {
                CytoscapeUtilities.notifyUser("Invalid input. Please enter an integer value.");
                continue;
            }
            this.exportNeighborsToCSV(network, Integer.parseInt(text));
            outcome = 2;
        }
    }

    private JPanel createExportNeighborsPanel() {
        JPanel exportNeighborsPanel = new JPanel();
        exportNeighborsPanel.setLayout(new BoxLayout(exportNeighborsPanel, 1));
        JPanel networkNamePanel = new JPanel();
        networkNamePanel.setLayout(new BoxLayout(networkNamePanel, 0));
        networkNamePanel.add(new JLabel("Select network: "));
        networkNamePanel.add(this.networkNameComboBoxRef);
        this.updateNetworkNameComboBoxRef();
        JPanel degreeInputPanel = new JPanel();
        degreeInputPanel.setLayout(new BoxLayout(degreeInputPanel, 0));
        this.neighborDegreeRef = new JTextField(5);
        this.neighborDegreeRef.setText("1");
        degreeInputPanel.add(new JLabel("Please specify the degree: "));
        degreeInputPanel.add(this.neighborDegreeRef);
        JPanel nodeAttrPanel = new JPanel();
        nodeAttrPanel.setLayout(new BoxLayout(nodeAttrPanel, 0));
        nodeAttrPanel.add(new JLabel("Select node attribute: "));
        this.updateNodeAttrComboBoxRef();
        nodeAttrPanel.add(this.nodeAttrComboBoxRef);
        exportNeighborsPanel.add(networkNamePanel);
        exportNeighborsPanel.add(nodeAttrPanel);
        exportNeighborsPanel.add(degreeInputPanel);
        return exportNeighborsPanel;
    }

    private JComboBox<String> createNetworkNameComboBoxRef() {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportNeighborsAction.this.updateNodeAttrComboBoxRef();
            }
        });
        return comboBox;
    }

    private void exportNeighborsToCSV(CyNetwork cyNetwork, int degree) {
        if (degree == 0) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Select a folder");
        fc.setApproveButtonText("Select");
        if (fc.showOpenDialog(this.cySwingApplicationServiceRef.getJFrame()) == 0) {
            try {
                String fileName = "/neighbor_list.csv";
                FileWriter writer = new FileWriter(fc.getSelectedFile().getAbsolutePath() + fileName);
                writer.append("Author");
                writer.append(',');
                writer.append("Neighbors");
                writer.append('\n');
                String attr = (String)this.nodeAttrComboBoxRef.getSelectedItem();
                if (!attr.equalsIgnoreCase("N/A")) {
                    for (CyNode node : cyNetwork.getNodeList()) {
                        writer.append((CharSequence)cyNetwork.getDefaultNodeTable().getRow((Object)node.getSUID()).get(attr, String.class));
                        writer.append(',');
                        this.writeNthDegreeNode(node, cyNetwork, writer, attr, degree);
                        writer.append('\n');
                    }
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("IOException. Unable to save csv file");
            }
        }
    }

    private JPanel getExportNeighborsPanelRef() {
        if (this.exportNeighborsPanelRef == null) {
            this.setExportNeighborsPanelRef(this.createExportNeighborsPanel());
        }
        return this.exportNeighborsPanelRef;
    }

    private void setExportNeighborsPanelRef(JPanel exportNeighborsPanelRef) {
        this.exportNeighborsPanelRef = exportNeighborsPanelRef;
    }

    private void updateNetworkNameComboBoxRef() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        Set networkSet = this.cyNetworkManagerServiceRef.getNetworkSet();
        String networkName = null;
        this.cyNetworkMap.clear();
        if (networkSet.isEmpty()) {
            networkName = "N/A";
            model.addElement(networkName);
        } else {
            Iterator it = networkSet.iterator();
            CyNetwork cyNetwork = null;
            while (it.hasNext()) {
                cyNetwork = (CyNetwork)it.next();
                networkName = SocialNetworkAppManager.getNetworkName(cyNetwork);
                model.addElement(networkName);
                this.cyNetworkMap.put(networkName, cyNetwork);
            }
        }
        this.networkNameComboBoxRef.setModel(model);
        this.networkNameComboBoxRef.setSelectedItem(networkName);
    }

    private void updateNodeAttrComboBoxRef() {
        String selectedItem = (String)this.networkNameComboBoxRef.getSelectedItem();
        CyNetwork cyNetwork = this.cyNetworkMap.get(selectedItem);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (cyNetwork == null) {
            model.addElement("N/A");
        } else {
            for (CyColumn col : cyNetwork.getDefaultNodeTable().getColumns()) {
                if (col.getType() != String.class) continue;
                model.addElement(col.getName());
            }
        }
        this.nodeAttrComboBoxRef.setModel(model);
    }

    private void writeNthDegreeNode(CyNode node, CyNetwork network, FileWriter writer, String attr, int depth) {
        if (depth == 0) {
            try {
                writer.append("(" + (String)network.getDefaultNodeTable().getRow((Object)node.getSUID()).get(attr, String.class) + ") ");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Exception occurred", e);
                CytoscapeUtilities.notifyUser("IOException. Unable to save csv file");
            }
            return;
        }
        for (CyNode neighbour : network.getNeighborList(node, CyEdge.Type.ANY)) {
            this.writeNthDegreeNode(neighbour, network, writer, attr, depth - 1);
        }
    }
}

