/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xmlbeans.impl.common.Levenshtein;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.IncitesInstitutionLocationMap;
import org.baderlab.csapps.socialnetwork.model.academia.PubMed;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.UnableToParseYearException;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.ParseScopus;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.IncitesParser;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.cytoscape.model.CyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Author
extends AbstractNode {
    private static final Logger logger = Logger.getLogger(Author.class.getName());
    private String department = "N/A";
    private String firstInitial = "?";
    private String firstName = "N/A";
    private String lastName = "N/A";
    private String location = "N/A";
    private String middleInitial = "N/A";
    private int timesCited = 0;
    private int origin = -1;
    private boolean identified = false;
    private boolean alreadyBeenAdded = false;
    private List<String> pubList = null;
    private Map<Integer, List<Publication>> yearToListOfPubsMap = null;
    private Map<Integer, Integer> yearToTimesCitedMap = null;
    private String mainInstitution = null;
    private List<String> institutionList = null;
    private int startYear = 0;
    private int endYear = 0;
    private double totalExpectedCitations = 0.0;
    private double expectedCitations = 0.0;

    public Author(String rawAuthorText, int origin) {
        this.setOrigin(origin);
        switch (origin) {
            case -960949447: {
                this.setNodeAttrMap(ParseScopus.constructScopusAttrMap());
                String[] scopusNames = rawAuthorText.split("\\s|,");
                if (scopusNames.length == 1) {
                    this.setLastName(scopusNames[0]);
                } else {
                    String lastName = scopusNames[0];
                    int i = 1;
                    for (i = 1; i < scopusNames.length - 1; ++i) {
                        lastName = lastName + " " + scopusNames[i];
                    }
                    this.setLastName(lastName);
                    String[] initials = scopusNames[i].split("\\.");
                    if (initials.length == 1) {
                        this.setFirstName(initials[0]);
                        this.setFirstInitial(initials[0]);
                    } else if (initials.length > 1) {
                        this.setFirstName(initials[0]);
                        this.setFirstInitial(initials[0]);
                        this.setMiddleInitial(initials[1]);
                    }
                }
                this.setLabel(this.getFirstInitial() + " " + this.getLastName());
                break;
            }
            case -2113004178: {
                this.setNodeAttrMap(PubMed.constructPubMedAttrMap());
                String[] pubmedNames = rawAuthorText.split("\\s");
                if (pubmedNames.length == 1) {
                    this.lastName = pubmedNames[0];
                    break;
                }
                if (pubmedNames.length <= 1) break;
                String lastName = pubmedNames[0];
                int i = 1;
                for (i = 1; i < pubmedNames.length - 1; ++i) {
                    lastName = lastName + " " + pubmedNames[i];
                }
                this.setLastName(lastName);
                if (pubmedNames[i].length() >= 2) {
                    this.setFirstInitial(pubmedNames[i].substring(0, 1));
                    this.setFirstName(this.getFirstInitial());
                    this.setMiddleInitial(pubmedNames[i].substring(1));
                } else {
                    this.setFirstInitial(pubmedNames[i]);
                    this.setFirstName(pubmedNames[i]);
                }
                this.setLabel(this.getFirstInitial() + " " + this.getLastName());
                break;
            }
            case -2: {
                String[] authorAttr = rawAuthorText.split(";");
                this.setLastName(authorAttr[0]);
                this.setFirstName(authorAttr[1]);
                this.setFirstInitial(this.getFirstName().substring(0, 1));
                this.setNodeAttrMap(null);
            }
        }
        this.format();
    }

    public Author(String rawAuthorText, int origin, IncitesInstitutionLocationMap locationMap) {
        this.setOrigin(origin);
        switch (origin) {
            case 1410511959: {
                this.setNodeAttrMap(IncitesParser.constructIncitesAttrMap());
                this.setFirstName(IncitesParser.parseFirstName(rawAuthorText));
                if (!this.getFirstName().equalsIgnoreCase("N/A")) {
                    this.setFirstInitial(this.getFirstName().substring(0, 1));
                }
                this.setMiddleInitial(IncitesParser.parseMiddleInitial(rawAuthorText));
                this.setLastName(IncitesParser.parseLastName(rawAuthorText));
                this.setLabel(this.getFirstName() + " " + this.getLastName());
                this.addInstitution(IncitesParser.parseInstitution(rawAuthorText));
                this.setLocation(locationMap.getLocationMap().get(this.getInstitution()));
            }
        }
        this.format();
    }

    public void addInstitution(String institution) {
        if (this.institutionList == null) {
            this.institutionList = new LinkedList<String>();
        }
        if (this.institutionList.isEmpty()) {
            this.setMainInstitution(institution);
            this.institutionList.add(institution);
        } else if (!this.institutionList.contains(institution)) {
            this.institutionList.add(institution);
        }
        this.getNodeAttrMap().put(NodeAttribute.INSTITUTIONS.toString(), new ArrayList<String>(this.institutionList));
    }

    public void addPublication(Publication publication) {
        int timesCited = this.getTimesCited();
        ArrayList listOfPublicationTitles = (ArrayList)this.getPubList();
        if (publication.isSingleAuthored()) {
            this.setAlreadyBeenAdded(!this.hasAlreadyBeenAdded());
            if (this.hasAlreadyBeenAdded()) {
                return;
            }
        }
        this.setTimesCited(timesCited + publication.getTimesCited());
        listOfPublicationTitles.add(publication.getTitle());
        this.setPubList(listOfPublicationTitles);
        this.updateYearToListOfPubsMap(publication);
        this.updateYearToTimesCitedMap(publication);
        if (this.nodeAttrMap.get(NodeAttribute.ACTUAL_EXPECTED_CITATIONS.toString()) != null) {
            this.updateExpectedCitations(publication);
        }
    }

    private void updateExpectedCitations(Publication publication) {
        this.totalExpectedCitations += publication.getExpectedCitations();
        this.expectedCitations = this.totalExpectedCitations / (double)this.getPubList().size();
        this.nodeAttrMap.put(NodeAttribute.ACTUAL_EXPECTED_CITATIONS.toString(), this.expectedCitations);
    }

    public double getExpectedCitations() {
        return this.expectedCitations;
    }

    public boolean equals(Object other) {
        Author otherAuthor = (Author)other;
        boolean isEqual = false;
        boolean isEqualFirstName = false;
        boolean isEqualLastName = false;
        if (this.getOrigin() == 1410511959 && otherAuthor.getOrigin() == 1410511959) {
            boolean isEqualInstitution = false;
            isEqualLastName = this.getLastName().equalsIgnoreCase(otherAuthor.getLastName());
            isEqualFirstName = this.isSameFirstName(otherAuthor.getFirstName());
            String myInstitution = this.getInstitution();
            String otherInstitution = otherAuthor.getInstitution();
            isEqualInstitution = myInstitution.equalsIgnoreCase(otherInstitution);
            if (isEqualLastName && isEqualFirstName && !isEqualInstitution) {
                this.prioritizeInstitution(this, otherAuthor);
                isEqualInstitution = true;
            }
            isEqual = isEqualLastName && isEqualFirstName && isEqualInstitution;
        } else if (this.getOrigin() == 1410511959 && otherAuthor.getOrigin() == -2 || this.getOrigin() == -2 && otherAuthor.getOrigin() == 1410511959) {
            isEqualLastName = this.getLastName().equalsIgnoreCase(otherAuthor.getLastName());
            isEqualFirstName = this.isSameFirstName(otherAuthor.getFirstName());
            boolean bl = isEqual = isEqualLastName && isEqualFirstName;
            if (isEqual) {
                otherAuthor.setIdenfitication(true);
            }
        } else if (this.getOrigin() == -2113004178 && otherAuthor.getOrigin() == -2113004178 || this.getOrigin() == -960949447 && otherAuthor.getOrigin() == -960949447) {
            isEqualLastName = this.getLastName().equalsIgnoreCase(otherAuthor.getLastName());
            isEqualFirstName = this.getFirstInitial().equalsIgnoreCase(otherAuthor.getFirstInitial());
            isEqual = isEqualFirstName && isEqualLastName;
        }
        return isEqual;
    }

    public void format() {
        try {
            if (this.getFirstName().length() > 0) {
                String firstName = this.getFirstName().substring(0, 1).toUpperCase() + this.getFirstName().substring(1).toLowerCase();
                this.setFirstName(firstName);
            }
            if (this.getLastName().length() > 0) {
                String lastName = this.getLastName().substring(0, 1).toUpperCase() + this.getLastName().substring(1).toLowerCase();
                this.setLastName(lastName);
            }
            this.setFirstInitial(this.getFirstInitial().toUpperCase());
            this.setMiddleInitial(this.getMiddleInitial().toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public CyNode getCyNode() {
        return this.cyNode;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getFirstInitial() {
        return this.firstInitial;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getInstitution() {
        String institution = "N/A";
        if (this.institutionList != null && this.institutionList.size() > 0) {
            institution = this.institutionList.get(0);
        }
        return institution;
    }

    public List<String> getInstitutions() {
        return this.institutionList;
    }

    @Override
    public String getLabel() {
        return this.label == null ? this.label : this.label.trim();
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMainInstitution() {
        return this.mainInstitution;
    }

    private String getMiddleInitial() {
        return this.middleInitial;
    }

    @Override
    public Map<String, Object> getNodeAttrMap() {
        if (this.nodeAttrMap == null) {
            this.nodeAttrMap = new HashMap();
        }
        return this.nodeAttrMap;
    }

    public int getOrigin() {
        return this.origin;
    }

    public List<String> getPubList() {
        if (this.pubList == null) {
            this.pubList = new ArrayList<String>();
        }
        return this.pubList;
    }

    private Map<Integer, List<Publication>> getYearToListOfPubsMap() {
        if (this.yearToListOfPubsMap == null) {
            this.yearToListOfPubsMap = new HashMap<Integer, List<Publication>>();
        }
        return this.yearToListOfPubsMap;
    }

    public int getTimesCited() {
        return this.timesCited;
    }

    public boolean hasAlreadyBeenAdded() {
        return this.alreadyBeenAdded;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result += 31 * result + (this.firstInitial == null ? 0 : this.firstInitial.hashCode());
        result += 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        return result;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    private boolean isSameFirstName(String name) {
        boolean isEqualFirstName = false;
        String firstname1 = this.getFirstName().split(" ").length > 1 ? this.getFirstName().split(" ")[0] : this.getFirstName();
        String firstname2 = name.split(" ").length > 1 ? name.split(" ")[0] : name;
        double distance = Levenshtein.distance((String)firstname1.toLowerCase(), (String)firstname2.toLowerCase());
        double similarity = 1.0 - distance / (double)Math.max(firstname1.length(), firstname2.length());
        if (similarity >= 0.75) {
            isEqualFirstName = true;
        } else if (firstname1.length() == 1 || firstname2.length() == 1 || firstname1.length() == 2 && firstname1.contains(".") || firstname2.length() == 2 && firstname2.contains(".")) {
            isEqualFirstName = firstname1.substring(0, 1).equalsIgnoreCase(firstname2.substring(0, 1));
        }
        return isEqualFirstName;
    }

    public void prioritizeInstitution(Author author, Author otherAuthor) {
        String location = author.getLocation();
        String otherLocation = otherAuthor.getLocation();
        IncitesInstitutionLocationMap locationMap = new IncitesInstitutionLocationMap();
        Map<String, Integer> rankMap = locationMap.getLocationRankingMap();
        int rank = 0;
        int otherRank = 0;
        if (rankMap.containsKey(location)) {
            rank = rankMap.get(location);
        }
        if (rankMap.containsKey(otherLocation)) {
            otherRank = rankMap.get(otherLocation);
        }
        if (rank > otherRank) {
            String mainInstitution = author.getMainInstitution();
            otherAuthor.setMainInstitution(mainInstitution);
            this.updateInstitutionRanking(otherAuthor, mainInstitution);
            otherAuthor.setLocation(author.getLocation());
        } else if (rank == otherRank) {
            Author[] randomAuthorArray = new Author[]{author, otherAuthor};
            Random rand = new Random();
            int i = rand.nextInt(2) + 0;
            String randomInstitution = randomAuthorArray[i].getInstitution();
            String randomLocation = randomAuthorArray[i].getLocation();
            otherAuthor.addInstitution(randomInstitution);
            this.updateInstitutionRanking(otherAuthor, randomInstitution);
            otherAuthor.setLocation(randomLocation);
        }
    }

    public void setAlreadyBeenAdded(boolean alreadyBeenAdded) {
        this.alreadyBeenAdded = alreadyBeenAdded;
    }

    @Override
    public void setCyNode(CyNode cyNode) {
        this.cyNode = cyNode;
    }

    public void setDepartment(String department) {
        this.department = department;
        this.getNodeAttrMap().put(NodeAttribute.DEPARTMENT.toString(), department);
    }

    public void setFirstInitial(String firstInitial) {
        this.firstInitial = firstInitial;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.getNodeAttrMap().put(NodeAttribute.FIRST_NAME.toString(), firstName);
    }

    private void setIdenfitication(boolean bool) {
        this.identified = bool;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
        this.getNodeAttrMap().put(NodeAttribute.LABEL.toString(), label);
    }

    public void setLastName(String lastName) {
        if (lastName.trim().isEmpty()) {
            return;
        }
        this.lastName = lastName;
        this.getNodeAttrMap().put(NodeAttribute.LAST_NAME.toString(), lastName);
    }

    public void setLocation(String location) {
        this.location = location == null ? (this.getInstitution().equalsIgnoreCase("N/A") ? "N/A" : "Other") : location;
        this.getNodeAttrMap().put(NodeAttribute.LOCATION.toString(), this.location);
    }

    public void setMainInstitution(String mainInstitution) {
        this.mainInstitution = mainInstitution;
        this.getNodeAttrMap().put(NodeAttribute.MAIN_INSTITUTION.toString(), mainInstitution);
    }

    public void setMiddleInitial(String middleInitial) {
        this.middleInitial = middleInitial;
    }

    @Override
    public void setNodeAttrMap(Map<String, Object> attrMap) {
        this.nodeAttrMap = attrMap;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public void setPubList(List<String> pubList) {
        this.pubList = pubList;
        this.getNodeAttrMap().put(NodeAttribute.PUBLICATIONS.toString(), pubList);
        this.getNodeAttrMap().put(NodeAttribute.PUBLICATION_COUNT.toString(), pubList.size());
    }

    public void setTimesCited(int timesCited) {
        this.timesCited = timesCited;
        this.getNodeAttrMap().put(NodeAttribute.TIMES_CITED.toString(), timesCited);
    }

    public String toString() {
        return this.lastName + ", " + this.firstName;
    }

    private void updateInstitutionRanking(Author author, String mainInstitution) {
        LinkedList ll = (LinkedList)author.getInstitutions();
        if (ll.contains(mainInstitution)) {
            ll.remove(mainInstitution);
        }
        ll.addFirst(mainInstitution);
    }

    private void updateYearToListOfPubsMap(Publication publication) {
        Map<Integer, List<Publication>> pubMap = this.getYearToListOfPubsMap();
        try {
            int pubYear = publication.getPubYear();
            List<Publication> listOfPubs = pubMap.get(pubYear);
            if (listOfPubs == null) {
                listOfPubs = new ArrayList<Publication>();
                listOfPubs.add(publication);
                pubMap.put(pubYear, listOfPubs);
            } else {
                listOfPubs.add(publication);
            }
        }
        catch (UnableToParseYearException e) {
            logger.log(Level.WARNING, String.format("Year could not be parsed from raw text: %s", publication.getRawPubDateTxt()));
        }
        if (this.getYearToListOfPubsMap().size() > 0) {
            Set<Integer> yearSet = pubMap.keySet();
            ArrayList<Integer> pubsPerYearList = new ArrayList<Integer>();
            int startYear = SocialNetworkAppManager.getStartYear();
            int endYear = SocialNetworkAppManager.getEndYear();
            int size = endYear - startYear + 1;
            pubsPerYearList = new ArrayList(size);
            for (int year = startYear; year <= endYear; ++year) {
                pubsPerYearList.add(yearSet.contains(year) ? pubMap.get(year).size() : 0);
            }
            this.getNodeAttrMap().put(NodeAttribute.PUBS_PER_YEAR.toString(), pubsPerYearList);
        }
    }

    private void updateYearToTimesCitedMap(Publication publication) {
        Map<Integer, Integer> yearToTimesCitedMap = this.getYearToTimesCitedMap();
        try {
            int pubYear = publication.getPubYear();
            Integer timesCited = yearToTimesCitedMap.get(pubYear);
            if (timesCited == null) {
                yearToTimesCitedMap.put(pubYear, publication.getTimesCited());
            } else {
                yearToTimesCitedMap.put(pubYear, timesCited + publication.getTimesCited());
            }
        }
        catch (UnableToParseYearException e) {
            logger.log(Level.WARNING, String.format("Year could not be parsed from raw text: %s", publication.getRawPubDateTxt()));
        }
        if (this.getYearToTimesCitedMap().size() > 0) {
            Set<Integer> yearSet = yearToTimesCitedMap.keySet();
            ArrayList<Integer> citationsPerYearList = new ArrayList<Integer>();
            int startYear = SocialNetworkAppManager.getStartYear();
            int endYear = SocialNetworkAppManager.getEndYear();
            int size = endYear - startYear + 1;
            citationsPerYearList = new ArrayList(size);
            for (int year = startYear; year <= endYear; ++year) {
                citationsPerYearList.add(yearSet.contains(year) ? yearToTimesCitedMap.get(year) : 0);
            }
            this.getNodeAttrMap().put(NodeAttribute.CITATIONS_PER_YEAR.toString(), citationsPerYearList);
        }
    }

    private Map<Integer, Integer> getYearToTimesCitedMap() {
        if (this.yearToTimesCitedMap == null) {
            this.yearToTimesCitedMap = new HashMap<Integer, Integer>();
        }
        return this.yearToTimesCitedMap;
    }
}

