/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interaction {
    private Map<Collaboration, ArrayList<AbstractEdge>> map = null;
    private int maxThreshold;
    private ArrayList<Publication> excludedPublications = null;

    public Interaction(Map<Collaboration, ArrayList<AbstractEdge>> academiamap, int type) {
        switch (type) {
            case -2113004178: 
            case 1249763952: {
                this.setAbstractMap(academiamap);
            }
        }
    }

    public Map<Collaboration, ArrayList<AbstractEdge>> getAbstractMap() {
        return this.map;
    }

    public ArrayList<Publication> getExcludedPublications() {
        if (this.excludedPublications == null) {
            this.setExcludedPublications(new ArrayList<Publication>());
        }
        return this.excludedPublications;
    }

    public int getMaxThreshold() {
        return this.maxThreshold;
    }

    private Map<Collaboration, ArrayList<AbstractEdge>> loadAbstractMap(List<? extends AbstractEdge> abstractEdgeList) {
        HashMap<Collaboration, ArrayList<AbstractEdge>> abstractMap = new HashMap<Collaboration, ArrayList<AbstractEdge>>();
        for (AbstractEdge abstractEdge : abstractEdgeList) {
            int j = 0;
            Collaboration collaboration = null;
            ArrayList<AbstractEdge> edgeList = null;
            AbstractNode node1 = null;
            AbstractNode node2 = null;
            for (int i = 0; i < abstractEdge.getNodes().size(); ++i) {
                node1 = abstractEdge.getNodes().get(i);
                for (j = i + 1; j < abstractEdge.getNodes().size(); ++j) {
                    node2 = abstractEdge.getNodes().get(j);
                    collaboration = new Collaboration(node1, node2);
                    if (!abstractMap.containsKey(collaboration)) {
                        edgeList = new ArrayList<AbstractEdge>();
                        edgeList.add(abstractEdge);
                        abstractMap.put(collaboration, edgeList);
                        continue;
                    }
                    ((ArrayList)abstractMap.get(collaboration)).add(abstractEdge);
                }
            }
        }
        return abstractMap;
    }

    private void setAbstractMap(Map<Collaboration, ArrayList<AbstractEdge>> abstractMap) {
        this.map = abstractMap;
    }

    public void setExcludedPublications(ArrayList<Publication> excludedPublications) {
        this.excludedPublications = excludedPublications;
    }

    public void setMaxThreshold(int maxThreshold) {
        this.maxThreshold = maxThreshold;
    }
}

