/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.awt.Component;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.baderlab.csapps.socialnetwork.panels.InfoPanel;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.baderlab.csapps.socialnetwork.tasks.CreateChartTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.HideAuthorsTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ShowAllNodesTaskFactory;
import org.cytoscape.application.events.SetSelectedNetworksEvent;
import org.cytoscape.application.events.SetSelectedNetworksListener;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialNetworkSelectedListener
implements SetSelectedNetworksListener {
    private static final Logger logger = Logger.getLogger(SocialNetworkSelectedListener.class.getName());
    private SocialNetworkAppManager appManager = null;
    private UserPanel userPanel = null;
    private SocialNetwork socialNetwork = null;
    private CytoPanel cytoPanelEast = null;
    private TaskManager<?, ?> taskManager = null;
    private HideAuthorsTaskFactory updateVisualStyleTaskFactory = null;
    private CyServiceRegistrar cyServiceRegistrarRef = null;
    private CyNetworkViewManager cyNetworkViewManagerServiceRef = null;
    private ShowAllNodesTaskFactory showAllNodesTaskFactory = null;
    private CreateChartTaskFactory createChartTaskFactory = null;

    public SocialNetworkSelectedListener(SocialNetworkAppManager appManager, CyServiceRegistrar cyServiceRegistrarRef, TaskManager<?, ?> taskManager, HideAuthorsTaskFactory updateVisualStyleTaskFactory, CyNetworkViewManager cyNetworkViewManagerServiceRef, ShowAllNodesTaskFactory showAllNodesTaskFactory, CreateChartTaskFactory createChartTaskFactory) {
        this.cyNetworkViewManagerServiceRef = cyNetworkViewManagerServiceRef;
        this.appManager = appManager;
        this.cyServiceRegistrarRef = cyServiceRegistrarRef;
        this.taskManager = taskManager;
        this.userPanel = this.appManager.getUserPanelRef();
        this.updateVisualStyleTaskFactory = updateVisualStyleTaskFactory;
        this.showAllNodesTaskFactory = showAllNodesTaskFactory;
        this.createChartTaskFactory = createChartTaskFactory;
    }

    private InfoPanel initializeInfoPanel() {
        return new InfoPanel(this.taskManager, this.updateVisualStyleTaskFactory, this.socialNetwork, this.cyServiceRegistrarRef, this.showAllNodesTaskFactory, this.createChartTaskFactory);
    }

    public void handleEvent(SetSelectedNetworksEvent event) {
        String name = null;
        for (CyNetwork network : event.getNetworks()) {
            name = SocialNetworkAppManager.getNetworkName(network);
            if (this.appManager.getSocialNetworkMap().containsKey(name)) {
                this.socialNetwork = this.appManager.getSocialNetworkMap().get(name);
                this.userPanel.updateNetworkSummaryPanel(this.socialNetwork);
                this.userPanel.addNetworkVisualStyle(this.socialNetwork);
                this.appManager.setCurrentlySelectedSocialNetwork(this.socialNetwork);
                if (network.getDefaultNodeTable().getColumn(NodeAttribute.PUBS_PER_YEAR.toString()) != null) {
                    int index;
                    CyNetworkView networkView = (CyNetworkView)this.cyNetworkViewManagerServiceRef.getNetworkViews(network).iterator().next();
                    this.socialNetwork.setNetworkView(networkView);
                    InfoPanel infoPanel = SocialNetworkAppManager.getInfoPanel();
                    if (infoPanel == null) {
                        infoPanel = this.initializeInfoPanel();
                        this.cyServiceRegistrarRef.registerService((Object)infoPanel, CytoPanelComponent.class, new Properties());
                        SocialNetworkAppManager.setInfoPanel(infoPanel);
                    } else {
                        infoPanel.update(this.socialNetwork);
                    }
                    if (this.cytoPanelEast.getState() == CytoPanelState.HIDE) {
                        this.cytoPanelEast.setState(CytoPanelState.DOCK);
                    }
                    if ((index = this.cytoPanelEast.indexOfComponent((Component)infoPanel)) == -1) {
                        return;
                    }
                    this.cytoPanelEast.setSelectedIndex(index);
                }
                return;
            }
            logger.log(Level.WARNING, String.format("Display Options panel disabled because %s does not contain the pubs per year attribute.", this.socialNetwork.getNetworkName()));
        }
        this.appManager.setCurrentlySelectedSocialNetwork(null);
        this.userPanel.addNetworkVisualStyle(null);
        this.userPanel.updateNetworkSummaryPanel(null);
    }
}

