/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.actions.ShowUserPanelAction;
import org.baderlab.csapps.socialnetwork.model.Category;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.baderlab.csapps.socialnetwork.panels.InfoPanel;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.baderlab.csapps.socialnetwork.tasks.CreateChartTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.HideAuthorsTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ShowAllNodesTaskFactory;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreSocialNetworksFromProp
implements SessionLoadedListener {
    private static final Logger logger = Logger.getLogger(RestoreSocialNetworksFromProp.class.getName());
    private SocialNetworkAppManager appManager = null;
    private CyServiceRegistrar cyServiceRegistrar = null;
    private CytoPanel cytoPanelWest = null;
    private CytoPanel cytoPanelEast = null;
    private ShowUserPanelAction userPanelAction = null;
    private CyNetworkViewManager viewManager = null;
    private UserPanel userPanel = null;
    private InfoPanel infoPanel = null;
    private TaskManager<?, ?> taskManager = null;
    private HideAuthorsTaskFactory updateVisualStyleTaskFactory = null;
    private ShowAllNodesTaskFactory showAllNodesTaskFactory = null;
    private CreateChartTaskFactory createChartTaskFactory = null;

    public RestoreSocialNetworksFromProp(SocialNetworkAppManager appManager, CyNetworkViewManager viewManager, CyServiceRegistrar cyServiceRegistrar, CySwingApplication cySwingApplicationService, ShowUserPanelAction userPanelAction, UserPanel userPanel, TaskManager<?, ?> taskManager, HideAuthorsTaskFactory updateVisualStyleTaskFactory, ShowAllNodesTaskFactory showAllNodesTaskFactory, CreateChartTaskFactory createChartTaskFactory) {
        this.appManager = appManager;
        this.viewManager = viewManager;
        this.cyServiceRegistrar = cyServiceRegistrar;
        this.cytoPanelWest = cySwingApplicationService.getCytoPanel(CytoPanelName.WEST);
        this.cytoPanelEast = cySwingApplicationService.getCytoPanel(CytoPanelName.EAST);
        this.userPanelAction = userPanelAction;
        this.userPanel = userPanel;
        this.taskManager = taskManager;
        this.updateVisualStyleTaskFactory = updateVisualStyleTaskFactory;
        this.showAllNodesTaskFactory = showAllNodesTaskFactory;
        this.createChartTaskFactory = createChartTaskFactory;
    }

    private void initializeInfoPanel(SocialNetwork socialNetwork) {
        this.infoPanel = new InfoPanel(this.taskManager, this.updateVisualStyleTaskFactory, socialNetwork, this.cyServiceRegistrar, this.showAllNodesTaskFactory, this.createChartTaskFactory);
    }

    public void handleEvent(SessionLoadedEvent e) {
        if (e.getLoadedSession().getAppFileListMap() == null || e.getLoadedSession().getAppFileListMap().size() == 0) {
            return;
        }
        List files = (List)e.getLoadedSession().getAppFileListMap().get("socialnetwork");
        if (files == null || files.size() == 0) {
            return;
        }
        String currentName = (String)this.userPanelAction.getValue("Name");
        if (currentName.trim().equalsIgnoreCase("Show Social Network")) {
            int index;
            this.cyServiceRegistrar.registerService((Object)this.userPanel, CytoPanelComponent.class, new Properties());
            if (this.cytoPanelWest.getState() == CytoPanelState.HIDE) {
                this.cytoPanelWest.setState(CytoPanelState.DOCK);
            }
            if ((index = this.cytoPanelWest.indexOfComponent((Component)this.userPanel)) == -1) {
                return;
            }
            this.cytoPanelWest.setSelectedIndex(index);
            this.userPanelAction.putValue("Name", "Hide Social Network");
        }
        try {
            File propFile = (File)files.get(0);
            BufferedReader in = new BufferedReader(new FileReader(propFile));
            in.readLine();
            String line = in.readLine();
            String[] networkData = null;
            ArrayList<String> listOfSocialNetworks = new ArrayList<String>();
            ArrayList<String> listOfTypes = new ArrayList<String>();
            ArrayList<String> listOfNumPubs = new ArrayList<String>();
            ArrayList<String> listOfNumFaculty = new ArrayList<String>();
            ArrayList<String> listOfNumUnidenFaculty = new ArrayList<String>();
            ArrayList<String> listOfStartYear = new ArrayList<String>();
            ArrayList<String> listOfEndYear = new ArrayList<String>();
            while (line != null) {
                networkData = line.split(",");
                listOfSocialNetworks.add(networkData[0]);
                listOfTypes.add(networkData[1]);
                listOfNumPubs.add(networkData[2]);
                listOfNumFaculty.add(networkData[3]);
                listOfNumUnidenFaculty.add(networkData[4]);
                listOfStartYear.add(networkData[5]);
                listOfEndYear.add(networkData[6]);
                line = in.readLine();
            }
            SocialNetwork socialNetwork = null;
            CyNetworkView networkView = null;
            Collection views = null;
            int index = -1;
            SocialNetwork network = null;
            for (CyNetwork n : e.getLoadedSession().getNetworks()) {
                index = listOfSocialNetworks.indexOf(n.toString());
                if (index <= -1) continue;
                socialNetwork = new SocialNetwork(n.toString(), Category.toCategory((String)listOfTypes.get(index)));
                socialNetwork.setCyNetwork(n);
                socialNetwork.setNum_publications(Integer.valueOf((String)listOfNumPubs.get(index)));
                socialNetwork.setNum_faculty(Integer.valueOf((String)listOfNumFaculty.get(index)));
                socialNetwork.setNum_uniden_faculty(Integer.valueOf((String)listOfNumUnidenFaculty.get(index)));
                socialNetwork.setStartYear(Integer.valueOf((String)listOfStartYear.get(index)));
                socialNetwork.setEndYear(Integer.valueOf((String)listOfEndYear.get(index)));
                views = this.viewManager.getNetworkViews(n);
                if (views.size() != 0) {
                    networkView = (CyNetworkView)views.iterator().next();
                }
                socialNetwork.setNetworkView(networkView);
                this.appManager.getSocialNetworkMap().put(n.toString(), socialNetwork);
                this.appManager.getUserPanelRef().addNetworkToNetworkPanel(socialNetwork);
                network = socialNetwork;
            }
            in.close();
            if (network != null) {
                CyNetwork cyNetwork = network.getCyNetwork();
                if (cyNetwork.getDefaultNodeTable().getColumn(NodeAttribute.PUBS_PER_YEAR.toString()) != null) {
                    if (SocialNetworkAppManager.getInfoPanel() == null) {
                        this.initializeInfoPanel(network);
                        this.cyServiceRegistrar.registerService((Object)this.infoPanel, CytoPanelComponent.class, new Properties());
                        SocialNetworkAppManager.setInfoPanel(this.infoPanel);
                    } else {
                        this.infoPanel.update(network);
                    }
                    if (this.cytoPanelEast.getState() == CytoPanelState.HIDE) {
                        this.cytoPanelEast.setState(CytoPanelState.DOCK);
                    }
                    if ((index = this.cytoPanelEast.indexOfComponent((Component)this.infoPanel)) == -1) {
                        return;
                    }
                    this.cytoPanelEast.setSelectedIndex(index);
                } else {
                    logger.log(Level.WARNING, String.format("Display Options panel disabled because %s does not contain the pubs per year attribute.", network.getNetworkName()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

