/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.baderlab.csapps.socialnetwork.tasks.ApplyVisualStyleTaskFactory;
import org.cytoscape.application.swing.CyMenuItem;
import org.cytoscape.application.swing.CyNodeViewContextMenuFactory;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateAuthorLocationAction
implements CyNodeViewContextMenuFactory,
ActionListener {
    private CyNode cyNode = null;
    private CyNetwork cyNetwork = null;
    private TaskManager<?, ?> taskManager = null;
    private ApplyVisualStyleTaskFactory applyVisualStyleTaskFactoryRef = null;

    @Override
    public void actionPerformed(ActionEvent e) {
        CyTable nodeTable = this.cyNetwork.getDefaultNodeTable();
        CyRow cyRow = nodeTable.getRow((Object)this.cyNode.getSUID());
        String authorName = (String)cyRow.getAllValues().get("Label");
        List listOfInstitutions = (List)cyRow.getAllValues().get(NodeAttribute.INSTITUTIONS.toString());
        if (listOfInstitutions != null && listOfInstitutions.size() > 0) {
            String institution = (String)listOfInstitutions.get(0);
            int outcome = CytoscapeUtilities.createDialogBox(String.format("Update location of %s", authorName), institution, this.cyNetwork, this.cyNode.getSUID());
            if (outcome == 0) {
                this.taskManager.execute(this.applyVisualStyleTaskFactoryRef.createTaskIterator());
            }
        } else {
            CytoscapeUtilities.notifyUser(String.format("%s is not assigned to an institution.", authorName));
        }
    }

    public UpdateAuthorLocationAction(TaskManager<?, ?> taskManager, ApplyVisualStyleTaskFactory applyVisualStyleTaskFactoryRef) {
        this.taskManager = taskManager;
        this.applyVisualStyleTaskFactoryRef = applyVisualStyleTaskFactoryRef;
    }

    public CyMenuItem createMenuItem(CyNetworkView netView, View<CyNode> nodeView) {
        this.cyNetwork = (CyNetwork)netView.getModel();
        this.cyNode = (CyNode)nodeView.getModel();
        JMenuItem addInstitutionMenuItem = new JMenuItem("Update Author's Location");
        addInstitutionMenuItem.addActionListener(this);
        CyMenuItem cyMenuItem = new CyMenuItem(addInstitutionMenuItem, 0.0f);
        return cyMenuItem;
    }
}

