/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.awt.Cursor;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.tasks.ParseIncitesXLSXTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ParsePubMedXMLTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ParseScopusCSVTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskManager;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseSocialNetworkFileTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(ParseSocialNetworkFileTask.class.getName());
    private TaskManager<?, ?> taskManagerServiceRef = null;
    private SocialNetworkAppManager appManager = null;
    private ParseIncitesXLSXTaskFactory parseIncitesXLSXTaskFactoryRef = null;
    private ParsePubMedXMLTaskFactory parsePubMedXMLTaskFactoryRef = null;
    private ParseScopusCSVTaskFactory parseScopusCSVTaskFactoryRef = null;

    public ParseSocialNetworkFileTask(SocialNetworkAppManager appManager, TaskManager<?, ?> taskManagerServiceRef, ParseIncitesXLSXTaskFactory parseIncitesXLSXTaskFactoryRef, ParsePubMedXMLTaskFactory parsePubMedXMLTaskFactoryRef, ParseScopusCSVTaskFactory parseScopusCSVTaskFactoryRef) {
        this.appManager = appManager;
        this.taskManagerServiceRef = taskManagerServiceRef;
        this.parseIncitesXLSXTaskFactoryRef = parseIncitesXLSXTaskFactoryRef;
        this.parsePubMedXMLTaskFactoryRef = parsePubMedXMLTaskFactoryRef;
        this.parseScopusCSVTaskFactoryRef = parseScopusCSVTaskFactoryRef;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        taskMonitor.setTitle("Loading Network ...");
        File networkFile = this.appManager.getNetworkFile();
        String networkName = this.appManager.getNetworkName();
        if (!this.appManager.isNameValid(networkName).booleanValue()) {
            String message = "Network " + networkName + " already exists in Cytoscape." + " Please enter a new name.";
            logger.log(Level.WARNING, message);
            CytoscapeUtilities.notifyUser(message);
            return;
        }
        this.appManager.getUserPanelRef().setCursor(new Cursor(3));
        String extension = FilenameUtils.getExtension((String)networkFile.getPath()).trim();
        switch (this.appManager.getAnalysis_type()) {
            case 1410511959: {
                if (!extension.equalsIgnoreCase("xlsx")) {
                    this.appManager.getUserPanelRef().setCursor(new Cursor(0));
                    String message = "Invalid file. InCites data files either have to be excel spreadsheets or text files.";
                    logger.log(Level.WARNING, message);
                    CytoscapeUtilities.notifyUser(message);
                    return;
                }
                this.visualizeIncitesXLSX();
                break;
            }
            case -2113004178: {
                if (!extension.equalsIgnoreCase("xml")) {
                    this.appManager.getUserPanelRef().setCursor(new Cursor(0));
                    String message = "Invalid file. PubMed data files have to be in xml format.";
                    logger.log(Level.WARNING, message);
                    CytoscapeUtilities.notifyUser(message);
                    return;
                }
                this.visualizePubMedXML();
                break;
            }
            case -960949447: {
                if (!extension.equalsIgnoreCase("csv")) {
                    this.appManager.getUserPanelRef().setCursor(new Cursor(0));
                    String message = "Invalid file. Scopus data files have to be csv spreadsheets";
                    logger.log(Level.WARNING, message);
                    CytoscapeUtilities.notifyUser(message);
                    return;
                }
                this.visualizeScopusCSV();
                break;
            }
        }
    }

    public TaskManager<?, ?> getTaskManager() {
        return this.taskManagerServiceRef;
    }

    public ParseIncitesXLSXTaskFactory getParseIncitesXLSXTaskFactoryRef() {
        return this.parseIncitesXLSXTaskFactoryRef;
    }

    public ParsePubMedXMLTaskFactory getParsePubMedXMLTaskFactoryRef() {
        return this.parsePubMedXMLTaskFactoryRef;
    }

    public ParseScopusCSVTaskFactory getParseScopusCSVTaskFactoryRef() {
        return this.parseScopusCSVTaskFactoryRef;
    }

    private void visualizeIncitesXLSX() {
        this.getTaskManager().execute(this.getParseIncitesXLSXTaskFactoryRef().createTaskIterator());
    }

    private void visualizePubMedXML() {
        this.getTaskManager().execute(this.getParsePubMedXMLTaskFactoryRef().createTaskIterator());
    }

    private void visualizeScopusCSV() {
        this.getTaskManager().execute(this.getParseScopusCSVTaskFactoryRef().createTaskIterator());
    }
}

