/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.tasks;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.baderlab.csapps.socialnetwork.model.VisualStyles;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.EdgeAttribute;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.NodeAttribute;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class HideAuthorsTask
extends AbstractTask {
    private static final Logger logger = Logger.getLogger(HideAuthorsTask.class.getName());
    private CyNetworkView cyNetworkView = null;
    private CyApplicationManager cyApplicationManager = null;
    private CyNetwork cyNetwork = null;
    private int startYear = -1;
    private int endYear = -1;

    public HideAuthorsTask(CyApplicationManager cyApplicationManagerServiceRef) {
        this.cyApplicationManager = cyApplicationManagerServiceRef;
        this.cyNetwork = cyApplicationManagerServiceRef.getCurrentNetwork();
        this.cyNetworkView = cyApplicationManagerServiceRef.getCurrentNetworkView();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        SocialNetwork socialNetwork = SocialNetworkAppManager.getSelectedSocialNetwork();
        this.cyNetwork = socialNetwork.getCyNetwork();
        this.cyNetworkView = socialNetwork.getNetworkView();
        if (this.cyNetworkView == null) {
            return;
        }
        int year = SocialNetworkAppManager.getSelectedYear();
        taskMonitor.setTitle(String.format("Filtering \"%s\" to year %d ...", socialNetwork.getNetworkName(), year));
        logger.log(Level.INFO, String.format("Loading %s Visual Style ... ", VisualStyles.toString(socialNetwork.getVisualStyleId())));
        this.startYear = socialNetwork.getStartYear();
        this.endYear = socialNetwork.getEndYear();
        Iterator edgeIt = this.cyNetwork.getEdgeList().iterator();
        HashSet<CyNode> selectedNodes = new HashSet<CyNode>();
        CyEdge edge = null;
        View edgeView = null;
        View sourceView = null;
        View targetView = null;
        CyTable defaultEdgeTable = this.cyNetwork.getDefaultEdgeTable();
        while (edgeIt.hasNext()) {
            edge = (CyEdge)edgeIt.next();
            edgeView = this.cyNetworkView.getEdgeView(edge);
            List pubsPerYear = (List)CytoscapeUtilities.getCyTableAttribute(defaultEdgeTable, edge.getSUID(), EdgeAttribute.PUBS_PER_YEAR.toString());
            if ((Integer)pubsPerYear.get(year - this.startYear) > 0) {
                selectedNodes.add(edge.getSource());
                selectedNodes.add(edge.getTarget());
                sourceView = this.cyNetworkView.getNodeView(edge.getSource());
                targetView = this.cyNetworkView.getNodeView(edge.getTarget());
                sourceView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)true);
                targetView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)true);
                edgeView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)true);
                continue;
            }
            edgeView.setLockedValue(BasicVisualLexicon.EDGE_VISIBLE, (Object)false);
        }
        Iterator nodeIt = this.cyNetwork.getNodeList().iterator();
        CyNode node = null;
        View nodeView = null;
        CyTable defaultNodeTable = this.cyNetwork.getDefaultNodeTable();
        while (nodeIt.hasNext()) {
            try {
                node = (CyNode)nodeIt.next();
                if (selectedNodes.contains(node)) continue;
                nodeView = this.cyNetworkView.getNodeView(node);
                nodeView.setLockedValue(BasicVisualLexicon.NODE_VISIBLE, (Object)false);
            }
            catch (Exception e) {
                String label = (String)CytoscapeUtilities.getCyTableAttribute(defaultNodeTable, node.getSUID(), NodeAttribute.LABEL.toString());
                logger.log(Level.WARNING, String.format("Unable to hide \"%s\" because %s", label.trim(), e.getMessage()));
            }
        }
        this.cyNetworkView.updateView();
    }
}

