/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

public class Query {
    private String query;

    public Query(String rawQuery) {
        this.query = rawQuery;
    }

    public Query(String rawQuery, String journal, String year, String limit) {
        rawQuery = rawQuery.replace(" ", "+");
        rawQuery = this.augmentYear(rawQuery, year);
        rawQuery = this.augmentJournal(rawQuery, journal);
        rawQuery = this.augmentHistory(rawQuery);
        this.query = this.augmentLimit(rawQuery, limit);
    }

    private String augmentHistory(String query) {
        return String.format("%s&usehistory=y", query);
    }

    private String augmentJournal(String query, String journal) {
        if (journal.trim().isEmpty()) {
            return query;
        }
        return String.format("%s[journal]+AND+%s", journal.toLowerCase(), query);
    }

    private String augmentLimit(String query, String limit) {
        if (limit.trim().isEmpty()) {
            return query;
        }
        return String.format("%s&retmax=%s", query, limit);
    }

    private String augmentYear(String query, String year) {
        if (year.trim().isEmpty()) {
            return query;
        }
        return String.format("%s+AND+%s[pdat]", query, year);
    }

    public String toString() {
        return this.query;
    }
}

