/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.UnableToParseYearException;
import org.baderlab.csapps.socialnetwork.model.academia.visualstyles.EdgeAttribute;
import org.cytoscape.model.CyEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Publication
extends AbstractEdge {
    private static final Logger logger = Logger.getLogger(Publication.class.getName());
    private ArrayList<Author> authorList = new ArrayList();
    private String expectedCitationsRawText = null;
    private String journal = null;
    private String location = "N/A";
    private String pubYear = null;
    private String timesCited = null;
    private String title = null;
    private String pmid = null;

    public Publication(String title, String pubYear, String journal, String timesCited, String expectedCitations, List<Author> coauthorList) {
        this.pubYear = pubYear;
        this.title = title;
        this.journal = journal;
        this.authorList.addAll(coauthorList);
        if (timesCited != null && Pattern.matches("[0-9]+", timesCited)) {
            this.timesCited = timesCited;
        }
        this.expectedCitationsRawText = expectedCitations;
        this.calculateLocation();
    }

    public void calculateLocation() {
        String maxlocation = "N/A";
        Integer max = 0;
        HashMap<String, Integer> all_locations = new HashMap<String, Integer>();
        for (Author author : this.authorList) {
            String current_location = author.getLocation();
            if (all_locations.containsKey(current_location)) {
                Integer count = (Integer)all_locations.get(current_location) + 1;
                all_locations.put(current_location, count);
                if (count <= max || current_location.equalsIgnoreCase("N/A")) continue;
                max = count;
                maxlocation = current_location;
                continue;
            }
            all_locations.put(current_location, 1);
        }
        this.location = maxlocation;
    }

    @Override
    public void constructEdgeAttrMap() {
        this.edgeAttrMap = new HashMap();
        this.edgeAttrMap.put(EdgeAttribute.TIMES_CITED.toString(), this.timesCited);
        this.edgeAttrMap.put(EdgeAttribute.PUBLICATION_DATE.toString(), this.pubYear);
        this.edgeAttrMap.put(EdgeAttribute.JOURNAL.toString(), this.journal);
        this.edgeAttrMap.put(EdgeAttribute.TITLE.toString(), this.title);
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        Publication otherPub = (Publication)obj;
        isEqual = otherPub.getTitle().equalsIgnoreCase(this.getTitle());
        isEqual = isEqual && otherPub.getTimesCited() == this.getTimesCited();
        return isEqual;
    }

    public ArrayList<Author> getAuthorList() {
        return this.authorList;
    }

    public String getAuthors() {
        String allAuthors = "";
        for (Author author : this.authorList) {
            allAuthors = allAuthors + author + ", ";
        }
        return allAuthors;
    }

    @Override
    public CyEdge getCyEdge() {
        return this.cyEdge;
    }

    @Override
    public Map<String, Object> getEdgeAttrMap() {
        return this.edgeAttrMap;
    }

    public double getExpectedCitations() {
        double expectedCitations = 0.0;
        if (this.expectedCitationsRawText != null && Pattern.matches("[0-9]+(\\.[0-9]+)?", this.expectedCitationsRawText)) {
            return Double.parseDouble(this.expectedCitationsRawText);
        }
        return expectedCitations;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public List<? extends AbstractNode> getNodes() {
        return this.authorList;
    }

    public String getPMID() {
        return this.pmid;
    }

    public int getPubYear() throws UnableToParseYearException {
        Pattern r;
        Matcher m;
        if (this.pubYear != null && (m = (r = Pattern.compile("\\d{4}")).matcher(this.pubYear)).find()) {
            return Integer.valueOf(m.group(0));
        }
        throw new UnableToParseYearException();
    }

    public String getRawPubDateTxt() {
        return this.pubYear;
    }

    public int getTimesCited() {
        if (this.timesCited != null && Pattern.matches("[0-9]+", this.timesCited)) {
            return Integer.parseInt(this.timesCited);
        }
        return 0;
    }

    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        int prime = 13;
        int result = 1;
        result += 13 * result + (this.title == null ? 0 : this.title.hashCode());
        result += 13 * result + (this.timesCited == null ? 0 : this.timesCited.hashCode());
        return result;
    }

    public boolean isSingleAuthored() {
        return this.authorList.size() == 2 && this.authorList.get(0).equals(this.authorList.get(1));
    }

    public void setAuthorList(ArrayList<Author> authorList) {
        this.authorList = authorList;
    }

    public void setAuthors(ArrayList<Author> authors) {
        this.authorList = authors;
    }

    @Override
    public void setCyEdge(CyEdge cyEdge) {
        this.cyEdge = cyEdge;
    }

    public void setExpectedCitations(String expectedCitations) {
        this.expectedCitationsRawText = expectedCitations;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPMID(String pmid) {
        this.pmid = pmid;
    }

    public void setPubYear(String pubYear) {
        this.pubYear = pubYear;
    }

    public void setTimesCited(int timesCited) {
        this.timesCited = String.valueOf(timesCited);
    }

    public void setTimesCited(String timesCited) {
        this.timesCited = timesCited;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return "Title: " + this.title + "\nTimes Cited: " + this.timesCited;
    }
}

