/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncitesInstitutionLocationMap {
    private static final Logger logger = Logger.getLogger(IncitesInstitutionLocationMap.class.getName());
    private Map<String, String> locationMap;
    private Map<String, Integer> locationRankingMap;

    public IncitesInstitutionLocationMap() {
        block8: {
            this.locationMap = null;
            this.locationRankingMap = null;
            if (this.locationMap != null) break block8;
            this.locationMap = new HashMap<String, String>();
            if (CytoscapeUtilities.getPropsReader() != null) {
                Properties props = CytoscapeUtilities.getPropsReader().getProperties();
                Iterator it = props.entrySet().iterator();
                Map.Entry item = null;
                String institution = null;
                String location = null;
                while (it.hasNext()) {
                    item = it.next();
                    institution = (String)item.getKey();
                    location = (String)item.getValue();
                    this.locationMap.put(institution, location);
                }
            } else {
                try {
                    InputStream in = this.getClass().getResourceAsStream("locationsmap.txt");
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    String sCurrentLine = null;
                    while ((sCurrentLine = br.readLine()) != null) {
                        String[] tokens = sCurrentLine.split("\t");
                        if (tokens.length == 2) {
                            this.locationMap.put(tokens[0], tokens[1]);
                            continue;
                        }
                        logger.log(Level.WARNING, "Misformed line in locationmap file\n \"" + sCurrentLine + "\n");
                    }
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, "Exception occurred", e);
                    CytoscapeUtilities.notifyUser("Failed to load location map. FileNotFoundException.");
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Exception occurred", e);
                    CytoscapeUtilities.notifyUser("Failed to load location map. IOException.");
                }
            }
        }
    }

    public Map<String, String> getLocationMap() {
        return this.locationMap;
    }

    public Map<String, Integer> getLocationRankingMap() {
        if (this.locationRankingMap == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            String[] locations = new String[]{"UNIV TORONTO", "Ontario", "Canada", "United States", "International", "Other"};
            for (int i = 0; i < 6; ++i) {
                map.put(locations[i], 6 - i);
            }
            this.setLocationRankingMap(map);
        }
        return this.locationRankingMap;
    }

    public void setLocationMap(Map<String, String> locationMap) {
        this.locationMap = locationMap;
    }

    private void setLocationRankingMap(Map<String, Integer> map) {
        this.locationRankingMap = map;
    }
}

