/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.actions.ShowUserPanelAction;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.VisualStyles;
import org.baderlab.csapps.socialnetwork.panels.InfoPanel;
import org.baderlab.csapps.socialnetwork.panels.UserPanel;
import org.baderlab.csapps.socialnetwork.tasks.ApplyVisualStyleTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.CreateNetworkTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.DestroyNetworkTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.ParseSocialNetworkFileTaskFactory;
import org.baderlab.csapps.socialnetwork.tasks.SearchPubMedTaskFactory;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.TaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocialNetworkAppManager {
    private static JTextField startDateTextFieldRef = null;
    private static JTextField endDateTextFieldRef = null;
    private static int selectedYear = -1;
    private static SocialNetwork selectedSocialNetwork = null;
    private static InfoPanel infoPanelRef = null;
    private static ApplyVisualStyleTaskFactory applyVisualStyleTaskFactoryRef = null;
    private SocialNetwork currentlySelectedSocialNetwork = null;
    private CyApplicationManager cyAppManagerServiceRef = null;
    private CyServiceRegistrar cyServiceRegistrarRef = null;
    private DestroyNetworkTaskFactory destroyNetworkTaskFactoryRef = null;
    private Map<Collaboration, ArrayList<AbstractEdge>> map = null;
    private String networkName = null;
    private CreateNetworkTaskFactory networkTaskFactoryRef = null;
    private CyNetwork networkToBeDestroyed = null;
    private Map<String, SocialNetwork> socialNetworkMap = null;
    private TaskManager<?, ?> taskManagerServiceRef = null;
    private ShowUserPanelAction userPanelAction = null;
    private UserPanel userPanelRef = null;
    private int visualStyleID = -1;
    private File networkFile = null;
    private int maxAuthorThreshold = -1;
    private int networkFileType = -1;
    private HashSet<String> visualStyleSet = null;
    public static final int ANALYSISTYPE_INCITES = 1410511959;
    public static final int ANALYSISTYPE_SCOPUS = -960949447;
    public static final int ANALYSISTYPE_PUBMED = -2113004178;
    private int analysis_type = 1410511959;
    private static final Logger logger = Logger.getLogger(SocialNetworkAppManager.class.getName());
    private CySwingApplication cySwingApp = null;
    private ParseSocialNetworkFileTaskFactory parseSocialNetworkFileTaskFactoryRef = null;
    private String searchTerm = null;
    private SearchPubMedTaskFactory searchPubMedTaskFactoryRef = null;
    private int neighborListDegree = 0;
    private CyNetwork neighborListNetwork = null;
    private File neighborListFolder = null;
    private String neighborListAttribute = null;

    public static InfoPanel getInfoPanel() {
        return infoPanelRef;
    }

    public static void setInfoPanel(InfoPanel infoPanel) {
        infoPanelRef = infoPanel;
    }

    public static SocialNetwork getSelectedSocialNetwork() {
        return selectedSocialNetwork;
    }

    public static void setSelectedSocialNetwork(SocialNetwork socialNetwork) {
        selectedSocialNetwork = socialNetwork;
    }

    public static int getSelectedYear() {
        return selectedYear;
    }

    public static void setSelectedYear(int year) {
        selectedYear = year;
    }

    public static JTextField getStartDateTextFieldRef() {
        if (startDateTextFieldRef == null) {
            int year = Calendar.getInstance().get(1) - 5;
            startDateTextFieldRef = new JTextField(String.valueOf(year));
            startDateTextFieldRef.setMaximumSize(new Dimension(Integer.MAX_VALUE, SocialNetworkAppManager.startDateTextFieldRef.getPreferredSize().height));
        }
        return startDateTextFieldRef;
    }

    public static JTextField getEndDateTextFieldRef() {
        if (endDateTextFieldRef == null) {
            int year = Calendar.getInstance().get(1);
            endDateTextFieldRef = new JTextField(String.valueOf(year));
            endDateTextFieldRef.setMaximumSize(new Dimension(Integer.MAX_VALUE, SocialNetworkAppManager.endDateTextFieldRef.getPreferredSize().height));
        }
        return endDateTextFieldRef;
    }

    public static ApplyVisualStyleTaskFactory getApplyVisualStyleTaskFactoryRef() {
        return applyVisualStyleTaskFactoryRef;
    }

    public static String getNetworkName(CyNetwork network) {
        ArrayList rowList = (ArrayList)network.getDefaultNetworkTable().getAllRows();
        CyRow row = (CyRow)rowList.get(0);
        String networkName = (String)row.getAllValues().get("name");
        return networkName;
    }

    public void applyVisualStyle(String visualStyle) {
        this.setVisualStyleID(new VisualStyles().getVisualStyleID(visualStyle));
        this.getTaskManager().execute(this.getApplyVisualStyleTaskFactoryRef().createTaskIterator());
    }

    public void closeUserPanel() {
        this.getServiceRegistrar().unregisterService((Object)this.getUserPanelRef(), CytoPanelComponent.class);
        this.getUserPanelAction().putValue("Name", "Show Social Network");
    }

    public void createNetwork(File networkFile, int maxAuthorThreshold) throws FileNotFoundException {
        this.setNetworkFile(networkFile);
        String networkName = this.getUserPanelRef().getAcademiaPanel().getFacultyTextFieldRef().getText().trim();
        this.setNetworkName(networkName);
        this.setMaxAuthorThreshold(maxAuthorThreshold);
        this.visualizeNetwork();
    }

    public static int getStartYear() {
        int startYear = -1;
        String startYearTxt = SocialNetworkAppManager.getStartDateTextFieldRef().getText().trim();
        if (Pattern.matches("[0-9]+", startYearTxt)) {
            startYear = Integer.parseInt(startYearTxt);
        }
        return startYear;
    }

    public static int getEndYear() {
        int endYear = -1;
        String endYearTxt = SocialNetworkAppManager.getEndDateTextFieldRef().getText().trim();
        if (Pattern.matches("[0-9]+", endYearTxt)) {
            endYear = Integer.parseInt(endYearTxt);
        }
        return endYear;
    }

    private void visualizeNetwork() {
        this.getTaskManager().execute(this.getParseSocialNetworkFileTaskFactory().createTaskIterator());
    }

    public void setParseSocialNetworkFileTaskFactory(ParseSocialNetworkFileTaskFactory parseSocialNetworkFileTaskFactoryRef) {
        this.parseSocialNetworkFileTaskFactoryRef = parseSocialNetworkFileTaskFactoryRef;
    }

    public ParseSocialNetworkFileTaskFactory getParseSocialNetworkFileTaskFactory() {
        return this.parseSocialNetworkFileTaskFactoryRef;
    }

    private void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void createNetwork(String searchTerm, int category, int maxAuthorThreshold) {
        switch (category) {
            case 1249763952: {
                this.setSearchTerm(searchTerm);
                this.setMaxAuthorThreshold(maxAuthorThreshold);
                this.searchPubMed();
            }
        }
    }

    public void destroyNetwork(CyNetwork network) {
        this.setNetworkToBeDestroyed(network);
        this.getTaskManager().execute(this.getDestroyNetworkTaskFactoryRef().createTaskIterator());
    }

    public int getAnalysis_type() {
        return this.analysis_type;
    }

    public SocialNetwork getCurrentlySelectedSocialNetwork() {
        return this.currentlySelectedSocialNetwork;
    }

    public CyApplicationManager getCyAppManagerServiceRef() {
        return this.cyAppManagerServiceRef;
    }

    public DestroyNetworkTaskFactory getDestroyNetworkTaskFactoryRef() {
        return this.destroyNetworkTaskFactoryRef;
    }

    public Map<Collaboration, ArrayList<AbstractEdge>> getMap() {
        return this.map;
    }

    public int getMaxAuthorThreshold() {
        return this.maxAuthorThreshold;
    }

    public File getNetworkFile() {
        return this.networkFile;
    }

    public int getNetworkFileType() {
        return this.networkFileType;
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public String[] getNetworkTableColumnNames() {
        return new String[]{"Name", "Node Count", "Edge Count", "Category"};
    }

    public CreateNetworkTaskFactory getNetworkTaskFactoryRef() {
        return this.networkTaskFactoryRef;
    }

    public CyNetwork getNetworkToBeDestroyed() {
        return this.networkToBeDestroyed;
    }

    public CyServiceRegistrar getServiceRegistrar() {
        return this.cyServiceRegistrarRef;
    }

    public SocialNetwork getSocialNetwork(String name) {
        if (this.socialNetworkMap != null && this.socialNetworkMap.containsKey(name)) {
            return this.socialNetworkMap.get(name);
        }
        return null;
    }

    public Map<String, SocialNetwork> getSocialNetworkMap() {
        if (this.socialNetworkMap == null) {
            this.setSocialNetworkMap(new HashMap<String, SocialNetwork>());
            this.socialNetworkMap.put("DEFAULT", new SocialNetwork("DEFAULT", -1));
        }
        return this.socialNetworkMap;
    }

    public TaskManager<?, ?> getTaskManager() {
        return this.taskManagerServiceRef;
    }

    public ShowUserPanelAction getUserPanelAction() {
        return this.userPanelAction;
    }

    public UserPanel getUserPanelRef() {
        return this.userPanelRef;
    }

    public int getVisualStyleID() {
        return this.visualStyleID;
    }

    public Boolean isNameValid(String name) {
        return !this.getSocialNetworkMap().containsKey(name);
    }

    public boolean isValidVisualStyle(String visualStyleName) {
        if (this.visualStyleSet == null) {
            this.visualStyleSet = new HashSet();
            this.visualStyleSet.add("Scopus");
            this.visualStyleSet.add("PubMed");
            this.visualStyleSet.add("InCites");
        }
        return this.visualStyleSet.contains(visualStyleName);
    }

    public void setAnalysis_type(int analysis_type) {
        this.analysis_type = analysis_type;
    }

    public void setApplyVisualStyleTaskFactoryRef(ApplyVisualStyleTaskFactory applyViewTaskFactoryRef) {
        applyVisualStyleTaskFactoryRef = applyViewTaskFactoryRef;
    }

    public void setCurrentlySelectedSocialNetwork(SocialNetwork currentlySelectedSocialNetwork) {
        this.currentlySelectedSocialNetwork = currentlySelectedSocialNetwork;
    }

    public void setCurrentNetworkView(String networkName) {
        CyNetworkView networkView = this.getSocialNetworkMap().get(networkName).getNetworkView();
        this.getCyAppManagerServiceRef().setCurrentNetworkView(networkView);
    }

    public void setCyAppManagerServiceRef(CyApplicationManager cyAppManagerServiceRef) {
        this.cyAppManagerServiceRef = cyAppManagerServiceRef;
    }

    public void setDestroyNetworkTaskFactoryRef(DestroyNetworkTaskFactory destroyNetworkTaskFactory) {
        this.destroyNetworkTaskFactoryRef = destroyNetworkTaskFactory;
    }

    public void setMap(Map<Collaboration, ArrayList<AbstractEdge>> map) {
        this.map = map;
    }

    private void setMaxAuthorThreshold(int maxAuthorThreshold) {
        this.maxAuthorThreshold = maxAuthorThreshold;
    }

    public void setNetworkFile(File networkFile) {
        this.networkFile = networkFile;
    }

    public void setNetworkFileType(int networkFileType) {
        this.networkFileType = networkFileType;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public void setNetworkTaskFactoryRef(CreateNetworkTaskFactory networkTaskFactoryRef) {
        this.networkTaskFactoryRef = networkTaskFactoryRef;
    }

    public void setNetworkToBeDestroyed(CyNetwork networkToBeDestroyed) {
        this.networkToBeDestroyed = networkToBeDestroyed;
    }

    public void setServiceRegistrar(CyServiceRegistrar cyServiceRegistrarRef) {
        this.cyServiceRegistrarRef = cyServiceRegistrarRef;
    }

    public void setSocialNetworkMap(Map<String, SocialNetwork> socialNetwork) {
        this.socialNetworkMap = socialNetwork;
    }

    public void setTaskManager(TaskManager<?, ?> taskManager) {
        this.taskManagerServiceRef = taskManager;
    }

    public void setUserPanelAction(ShowUserPanelAction userPanelAction) {
        this.userPanelAction = userPanelAction;
    }

    public void setUserPanelRef(UserPanel userPanelRef) {
        this.userPanelRef = userPanelRef;
    }

    public void setVisualStyleID(int visualStyleID) {
        this.visualStyleID = visualStyleID;
    }

    private void searchPubMed() {
        this.getTaskManager().execute(this.getSearchPubMedTaskFactoryRef().createTaskIterator());
    }

    private SearchPubMedTaskFactory getSearchPubMedTaskFactoryRef() {
        return this.searchPubMedTaskFactoryRef;
    }

    public void setSearchPubMedTaskFactoryRef(SearchPubMedTaskFactory searchPubMedTaskFactoryRef) {
        this.searchPubMedTaskFactoryRef = searchPubMedTaskFactoryRef;
    }

    public void setNeighborListDegree(int degree) {
        this.neighborListDegree = degree;
    }

    public int getNeighborListDegree() {
        return this.neighborListDegree;
    }

    public void setNeighborListNetwork(CyNetwork network) {
        this.neighborListNetwork = network;
    }

    public CyNetwork getNeighborListNetwork() {
        return this.neighborListNetwork;
    }

    public void setNeighborListFolder(File folder) {
        this.neighborListFolder = folder;
    }

    public File getNeighborListFolder() {
        return this.neighborListFolder;
    }

    public void setNeighborListAttribute(String attribute) {
        this.neighborListAttribute = attribute;
    }

    public String getNeighborListAttribute() {
        return this.neighborListAttribute;
    }

    public CySwingApplication getCySwingApp() {
        return this.cySwingApp;
    }

    public void setCySwingApp(CySwingApplication cySwingApp) {
        this.cySwingApp = cySwingApp;
    }
}

