/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.listeners;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.model.Category;
import org.baderlab.csapps.socialnetwork.model.SocialNetwork;
import org.baderlab.csapps.socialnetwork.model.SocialNetworkAppManager;
import org.cytoscape.session.events.SessionAboutToBeSavedEvent;
import org.cytoscape.session.events.SessionAboutToBeSavedListener;

public class SaveSocialNetworkToProp
implements SessionAboutToBeSavedListener {
    private SocialNetworkAppManager appManager = null;

    public SaveSocialNetworkToProp(SocialNetworkAppManager appManager) {
        this.appManager = appManager;
    }

    public void handleEvent(SessionAboutToBeSavedEvent e) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        File propFile = new File(tmpDir, "socialnetwork.props");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(propFile));
            writer.write("name,type,pub_total,faculty_total,faculty_uniden_total");
            writer.newLine();
            Iterator<Map.Entry<String, SocialNetwork>> it = this.appManager.getSocialNetworkMap().entrySet().iterator();
            Map.Entry<String, SocialNetwork> pair = null;
            String networkName = null;
            String type = null;
            String numPub = null;
            String numFaculty = null;
            String numFacultyUniden = null;
            String startYear = null;
            String endYear = null;
            SocialNetwork socialNetwork = null;
            while (it.hasNext()) {
                pair = it.next();
                networkName = pair.getKey();
                socialNetwork = pair.getValue();
                type = Category.toString(socialNetwork.getNetworkType());
                numPub = String.valueOf(socialNetwork.getNum_publications());
                numFaculty = String.valueOf(socialNetwork.getNum_faculty());
                numFacultyUniden = String.valueOf(socialNetwork.getNum_uniden_faculty());
                startYear = String.valueOf(socialNetwork.getStartYear());
                endYear = String.valueOf(socialNetwork.getEndYear());
                writer.write(networkName + "," + type + "," + numPub + "," + numFaculty + "," + numFacultyUniden + "," + startYear + "," + endYear);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(propFile);
        try {
            e.addAppFiles("socialnetwork", files);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

