/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import java.util.Enumeration;
import java.util.Hashtable;
import netmatch.algorithm.AttrComparator;
import netmatch.algorithm.myInteger;

public class exactEdgeComparator
implements AttrComparator {
    public boolean compatible(Object o1, Object o2) {
        Hashtable h1 = (Hashtable)o1;
        Hashtable h2 = (Hashtable)o2;
        Hashtable<String, myInteger> tmp1 = new Hashtable<String, myInteger>();
        Hashtable<String, myInteger> tmp2 = new Hashtable<String, myInteger>(h2);
        Enumeration e1 = h1.keys();
        while (e1.hasMoreElements()) {
            String key = (String)e1.nextElement();
            myInteger i1 = (myInteger)h1.get(key);
            if (key.startsWith("?")) {
                tmp1.put(key, i1);
                continue;
            }
            if (h2.containsKey(key)) {
                myInteger i2 = (myInteger)h2.get(key);
                if (i1.great(i2)) {
                    return false;
                }
                tmp2.remove(key);
                if (i2.intValue() - i1.intValue() <= 0) continue;
                tmp2.put(key, new myInteger(i2.intValue() - i1.intValue()));
                continue;
            }
            return false;
        }
        while (!tmp1.isEmpty()) {
            int max = this.extractMax(tmp1);
            if (this.isFeasible(tmp2, max)) continue;
            return false;
        }
        return true;
    }

    private int extractMax(Hashtable tmp) {
        int max = 0;
        String maxkey = null;
        Enumeration e1 = tmp.keys();
        while (e1.hasMoreElements()) {
            String key = (String)e1.nextElement();
            myInteger i1 = (myInteger)tmp.get(key);
            if (max >= i1.intValue()) continue;
            maxkey = key;
            max = i1.intValue();
        }
        tmp.remove(maxkey);
        return max;
    }

    private boolean isFeasible(Hashtable tmp, int val) {
        int min = Integer.MAX_VALUE;
        String minkey = null;
        Enumeration e1 = tmp.keys();
        while (e1.hasMoreElements()) {
            String key = (String)e1.nextElement();
            myInteger i1 = (myInteger)tmp.get(key);
            if (min < i1.intValue() || i1.intValue() < val) continue;
            minkey = key;
            min = i1.intValue();
        }
        if (minkey != null) {
            tmp.remove(minkey);
            return true;
        }
        return false;
    }

    public void printHashTable(Hashtable h) {
        Enumeration e1 = h.keys();
        while (e1.hasMoreElements()) {
            String key = (String)e1.nextElement();
            myInteger i1 = (myInteger)h.get(key);
            System.out.println(key + " " + i1.toString());
        }
    }
}

