/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import java.awt.Component;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import netmatch.qtool.QElement;
import netmatch.qtool.QNode;
import netmatch.qtool.QText;
import netmatch.qtool.QToolFrame;

public class QSelectHandler
extends PSelectionEventHandler {
    private QToolFrame frame;

    public QSelectHandler(PNode pNode, PNode pNodel, QToolFrame frame) {
        super(pNode, pNodel);
        this.frame = frame;
    }

    public void decorateSelectedNode(PNode node) {
        node.setPaint((Paint)QNode.SELECTED_NODE_COLOR);
        super.decorateSelectedNode(node);
    }

    public void undecorateSelectedNode(PNode node) {
        node.setPaint((Paint)QNode.NODE_COLOR);
        super.undecorateSelectedNode(node);
    }

    public void mouseMoved(PInputEvent event) {
        super.mouseMoved(event);
        this.showInfo(event);
    }

    /*
     * WARNING - void declaration
     */
    private void showInfo(PInputEvent event) {
        void var2_2;
        QElement elem;
        if (event.getPickedNode() instanceof QText) {
            elem = ((QText)event.getPickedNode()).getOwner();
        } else if (event.getPickedNode() instanceof QElement) {
            elem = (QElement)event.getPickedNode();
        } else {
            this.frame.infoArea.setText("");
            return;
        }
        this.frame.infoArea.setText(var2_2.getInfo());
    }

    public void mouseClicked(PInputEvent event) {
        super.mouseClicked(event);
        if (event.isRightMouseButton()) {
            this.showPopup(event);
        }
    }

    private void showPopup(PInputEvent event) {
        QElement popupElement;
        Point2D pos = event.getPosition();
        int x = (int)pos.getX();
        int y = (int)pos.getY();
        if (event.getPickedNode() instanceof QText) {
            popupElement = ((QText)event.getPickedNode()).getOwner();
        } else {
            if (!(event.getPickedNode() instanceof QElement)) {
                return;
            }
            popupElement = (QElement)event.getPickedNode();
        }
        this.frame.popup.show((Component)event.getComponent(), x, y, popupElement);
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        Collection selectedNodes = this.getSelectionReference();
        Iterator it = selectedNodes.iterator();
        while (it.hasNext()) {
            PNode node = (PNode)it.next();
            if (!(node instanceof QNode)) continue;
            ((QNode)node).update();
        }
    }

    protected void startDrag(PInputEvent e) {
        super.startDrag(e);
    }

    public void select(PNode node) {
        if (node instanceof QText) {
            super.select((PNode)((QText)node).getOwner());
        } else {
            super.select(node);
        }
    }

    protected PNodeFilter createNodeFilter(PBounds bounds) {
        return new MyBoundsFilter(bounds);
    }

    protected class MyBoundsFilter
    extends PSelectionEventHandler.BoundsFilter {
        protected MyBoundsFilter(PBounds bounds) {
            super((PSelectionEventHandler)QSelectHandler.this, bounds);
        }

        public boolean accept(PNode node) {
            if (node instanceof QText) {
                return false;
            }
            return super.accept(node);
        }

        public boolean acceptChildrenOf(PNode node) {
            if (node instanceof QText) {
                return false;
            }
            return super.acceptChildrenOf(node);
        }

        public boolean isCameraLayer(PNode node) {
            return super.isCameraLayer(node);
        }
    }
}

