/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import netmatch.qtool.QElement;
import netmatch.qtool.QNode;

public class QLoop
extends PPath
implements QElement {
    private static final Color LOOP_COLOR = new Color(33, 33, 119);
    private static final PFixedWidthStroke eStroke = new PFixedWidthStroke(2.0f);
    private QNode owner;
    private String attr = "?";
    private String id;
    private int valence = 0;

    public QLoop(QNode owner, String id) {
        super((Shape)new Ellipse2D.Float(0.0f, 0.0f, 20.0f, 20.0f));
        this.id = id;
        this.owner = owner;
        this.setStroke((Stroke)eStroke);
        this.setStrokePaint(LOOP_COLOR);
        this.update();
    }

    public void delete(PLayer nodeLayer, PLayer edgeLayer) {
        this.owner.removeLoop(this);
        edgeLayer.removeChild((PNode)this);
    }

    public String getInfo() {
        return "Edge\nId: " + this.id + "\n" + "Attribute: " + this.attr + "\n" + "Parent Id: " + this.getOwner().getId() + "\n";
    }

    public String getId() {
        return this.id;
    }

    public void update() {
        Point2D center = this.owner.getFullBoundsReference().getCenter2D();
        double width = this.owner.getFullBoundsReference().getWidth() * (0.7 + (double)this.valence * 0.15);
        double height = this.owner.getFullBoundsReference().getHeight() * (0.7 + (double)this.valence * 0.15);
        this.setWidth(width);
        this.setHeight(height);
        this.centerBoundsOnPoint(center.getX(), center.getY() - height / 2.0);
    }

    public QNode getOwner() {
        return this.owner;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getAttr() {
        return this.attr;
    }

    public void setValence(int newValence) {
        this.valence = newValence;
    }

    public int getValence() {
        return this.valence;
    }
}

