/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import giny.model.GraphPerspective;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import netmatch.algorithm.BfsPath;
import netmatch.algorithm.Common;
import netmatch.algorithm.Graph;
import netmatch.algorithm.GraphLoader;
import netmatch.algorithm.Pair;
import netmatch.algorithm.VF2MonoState;
import netmatch.algorithm.approxEdgeComparator;
import netmatch.algorithm.approxNodeComparator;
import netmatch.algorithm.exactEdgeComparator;
import netmatch.algorithm.exactNodeComparator;
import netmatch.algorithm.myInteger;
import netmatch.algorithm.myMatch;
import phoebe.PGraphView;

public class netMatch
implements Task {
    private JFrame frame;
    private CyNetwork target;
    private CyNetwork query;
    private TaskMonitor taskMonitor;
    private boolean interrupted;
    private boolean completedSuccessfully;
    private ArrayList array;
    private ArrayList source;
    private Image[] imageList;
    private String qea;
    private String qna;
    private ArrayList tea;
    private ArrayList tna;
    private GraphLoader qeLoader;
    private boolean isUsedEditor;
    private boolean isApproximate;
    private Vector qPaths;
    private ArrayList allPaths;

    public netMatch(JFrame frame, CyNetwork target, ArrayList tea, ArrayList tna, CyNetwork query, String qea, String qna) {
        this.frame = frame;
        this.target = target;
        this.query = query;
        this.tea = tea;
        this.tna = tna;
        this.qea = qea;
        this.qna = qna;
        this.taskMonitor = null;
        this.interrupted = false;
        this.completedSuccessfully = false;
        this.array = null;
        this.imageList = null;
        this.source = null;
        this.isUsedEditor = false;
        this.isApproximate = false;
        this.qPaths = null;
        this.allPaths = null;
    }

    public void printArrayList(ArrayList l) {
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            System.out.print(o + " ");
        }
        System.out.println();
    }

    public netMatch(JFrame frame, CyNetwork target, ArrayList tea, ArrayList tna, GraphLoader gl, boolean isQueryApproximate, Vector paths) {
        this.frame = frame;
        this.target = target;
        this.tea = tea;
        this.tna = tna;
        this.qeLoader = gl;
        this.taskMonitor = null;
        this.interrupted = false;
        this.completedSuccessfully = false;
        this.array = null;
        this.imageList = null;
        this.source = null;
        this.isUsedEditor = true;
        this.isApproximate = isQueryApproximate;
        this.qPaths = paths;
        this.allPaths = null;
    }

    public GraphLoader loadGraphFromNetwork(CyNetwork network, ArrayList edgeAttr, ArrayList nodeAttr) throws Exception {
        Hashtable<String, Integer> names = new Hashtable<String, Integer>();
        int k = 0;
        int i = 0;
        GraphLoader loader = new GraphLoader(this.frame);
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        int size = network.getNodeCount() + network.getEdgeCount();
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            CyNode node = (CyNode)it.next();
            String name1 = node.getIdentifier();
            ArrayList name1Attr = this.getAttribute(nodesAttributes, node.getIdentifier(), nodeAttr);
            if (!names.containsKey(name1)) {
                names.put(name1, new Integer(i++));
                name1Attr.add(0, name1 + "[STDEDGE]");
                loader.InsertNode(name1Attr, node.getRootGraphIndex(), false);
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        it = network.edgesIterator();
        while (it.hasNext()) {
            CyEdge edge = (CyEdge)it.next();
            ArrayList edge2Attr = this.getAttribute(edgesAttributes, edge.getIdentifier(), edgeAttr);
            CyNode source = (CyNode)edge.getSource();
            CyNode dest = (CyNode)edge.getTarget();
            String name1 = source.getIdentifier();
            String name2 = dest.getIdentifier();
            ArrayList name2Attr = this.getAttribute(nodesAttributes, dest.getIdentifier(), nodeAttr);
            boolean any = false;
            if (name1.equals(name2)) {
                if (!names.containsKey(name2 = name2 + "[SELFEDGE]")) {
                    names.put(name2, new Integer(i++));
                    name2Attr.add(0, name2);
                    loader.InsertNode(name2Attr, source.getRootGraphIndex(), true);
                }
                any = true;
            }
            if (any) {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), edge2Attr, true);
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), edge2Attr, true);
                }
            } else {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), edge2Attr, false);
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), edge2Attr, false);
                }
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        return loader;
    }

    public GraphLoader loadGraphFromNetwork(CyNetwork network, String edgeAttr, String nodeAttr) throws Exception {
        Hashtable<String, Integer> names = new Hashtable<String, Integer>();
        int k = 0;
        int i = 0;
        GraphLoader loader = new GraphLoader(this.frame);
        CyAttributes nodesAttributes = Cytoscape.getNodeAttributes();
        CyAttributes edgesAttributes = Cytoscape.getEdgeAttributes();
        int size = network.getNodeCount() + network.getEdgeCount();
        Iterator it = network.nodesIterator();
        while (it.hasNext()) {
            CyNode node = (CyNode)it.next();
            String name1 = node.getIdentifier();
            String name1Attr = this.getAttribute(nodesAttributes, node.getIdentifier(), nodeAttr);
            if (!names.containsKey(name1)) {
                names.put(name1, new Integer(i++));
                loader.InsertNode(name1Attr, node.getRootGraphIndex(), false);
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        it = network.edgesIterator();
        while (it.hasNext()) {
            CyEdge edge = (CyEdge)it.next();
            String type = this.getAttribute(edgesAttributes, edge.getIdentifier(), edgeAttr);
            CyNode source = (CyNode)edge.getSource();
            CyNode dest = (CyNode)edge.getTarget();
            String name1 = source.getIdentifier();
            String name2 = dest.getIdentifier();
            String name2Attr = this.getAttribute(nodesAttributes, dest.getIdentifier(), nodeAttr);
            boolean any = false;
            if (name1.equals(name2)) {
                name2 = name2 + "[SELFEDGE]";
                name2Attr = name2Attr + "[SELFEDGE]";
                if (!names.containsKey(name2)) {
                    names.put(name2, new Integer(i++));
                    loader.InsertNode(name2Attr, source.getRootGraphIndex(), true);
                }
                any = true;
            }
            if (any) {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type, true);
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type, true);
                }
            } else {
                loader.InsertEdge((Integer)names.get(name1), (Integer)names.get(name2), type, false);
                if (!Common.DIRECTED) {
                    loader.InsertEdge((Integer)names.get(name2), (Integer)names.get(name1), type, false);
                }
            }
            this.taskMonitor.setPercentCompleted(++k * 100 / size);
            if (!this.checkTask()) continue;
            return null;
        }
        return loader;
    }

    private ArrayList getAttribute(CyAttributes attributes, String id, ArrayList attrs) {
        ArrayList list = new ArrayList();
        try {
            if (attributes != null) {
                for (int i = 0; i < attrs.size(); ++i) {
                    Object type = null;
                    boolean isList = false;
                    String attr = (String)attrs.get(i);
                    if (attr.equals("Use node ID's as Attributes")) {
                        type = id;
                    } else if (attributes.getType(attr) == 4) {
                        type = attributes.getStringAttribute(id, attr);
                    } else if (attributes.getType(attr) == 1) {
                        type = attributes.getBooleanAttribute(id, attr);
                    } else if (attributes.getType(attr) == 2) {
                        type = attributes.getDoubleAttribute(id, attr);
                    } else if (attributes.getType(attr) == 3) {
                        type = attributes.getIntegerAttribute(id, attr);
                    } else if (attributes.getType(attr) == -2) {
                        List temp = attributes.getAttributeList(id, attr);
                        for (int ii = 0; ii < temp.size(); ++ii) {
                            list.add(temp.get(ii));
                        }
                        isList = true;
                    }
                    if (isList) continue;
                    if (type == null || type.equals("null")) {
                        type = "?_" + id;
                        System.out.println("NODE:" + type);
                    }
                    list.add(type);
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return list;
    }

    private String getAttribute(CyAttributes attributes, String id, String attr) {
        String type = null;
        try {
            if (attributes != null) {
                if (attr.equals("Use node ID's as Attributes")) {
                    type = id;
                } else if (attributes.getType(attr) == 4) {
                    type = attributes.getStringAttribute(id, attr);
                } else if (attributes.getType(attr) == 1) {
                    type = attributes.getBooleanAttribute(id, attr).toString();
                } else if (attributes.getType(attr) == 2) {
                    type = attributes.getDoubleAttribute(id, attr).toString();
                } else if (attributes.getType(attr) == 3) {
                    type = attributes.getIntegerAttribute(id, attr).toString();
                }
            }
            if (type == null || type.equals("null")) {
                type = "?_" + id;
            }
        }
        catch (NullPointerException e) {
            type = "?_" + id;
        }
        return type;
    }

    public boolean isCompletedSuccessfully() {
        return this.completedSuccessfully;
    }

    public String getTitle() {
        return "NetMatch";
    }

    public ArrayList getApproximatePaths() {
        return this.allPaths;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long end;
        long start;
        block25: {
            GraphPerspective[] gpComplexArray;
            block26: {
                if (this.taskMonitor == null) {
                    throw new IllegalStateException("Task Monitor is not set.");
                }
                try {
                    this.taskMonitor.setPercentCompleted(0);
                    this.taskMonitor.setStatus("Create Network Loader (Step 1 of 5)");
                    GraphLoader dbLoader = this.loadGraphFromNetwork(this.target, this.tea, this.tna);
                    if (this.checkTask()) {
                        return;
                    }
                    this.taskMonitor.setPercentCompleted(0);
                    this.taskMonitor.setStatus("Create Network Graph Data (Step 2 of 5)");
                    Graph db = new Graph(dbLoader, this);
                    if (this.checkTask()) {
                        return;
                    }
                    this.taskMonitor.setPercentCompleted(0);
                    this.taskMonitor.setStatus("Create Query Loader (Step 3 of 5)");
                    GraphLoader qLoader = this.isUsedEditor ? this.qeLoader : this.loadGraphFromNetwork(this.query, this.qea, this.qna);
                    if (this.checkTask()) {
                        return;
                    }
                    this.taskMonitor.setPercentCompleted(0);
                    this.taskMonitor.setStatus("Create Query Graph Data (Step 4 of 5)");
                    Graph q = new Graph(qLoader, this);
                    if (Common.LABELED) {
                        q.SetNodeComparator(new exactNodeComparator());
                        q.SetEdgeComparator(new exactEdgeComparator());
                    } else {
                        q.SetNodeComparator(new approxNodeComparator());
                        q.SetEdgeComparator(new approxEdgeComparator());
                    }
                    if (this.checkTask()) {
                        return;
                    }
                    this.taskMonitor.setPercentCompleted(-1);
                    this.taskMonitor.setStatus("Start Matching... (Step 5 of 5)");
                    VF2MonoState s0 = new VF2MonoState(q, db);
                    if (this.checkTask()) {
                        return;
                    }
                    this.array = new ArrayList();
                    this.source = new ArrayList();
                    Date d = new Date();
                    start = d.getTime();
                    myMatch m = new myMatch(this, this.frame);
                    myInteger val = m.match(s0, this.array, this.source);
                    d = new Date();
                    end = d.getTime();
                    if (this.checkTask()) {
                        return;
                    }
                    if (val.intValue() <= 0) break block25;
                    if (this.isApproximate) {
                        ArrayList l2 = this.getArrayDest();
                        ArrayList l1 = this.getArraySource();
                        ArrayList<int[]> l3 = new ArrayList<int[]>();
                        ArrayList<int[]> l4 = new ArrayList<int[]>();
                        this.allPaths = new ArrayList();
                        ArrayList<int[]> paths = null;
                        for (int j = 0; j < l2.size(); ++j) {
                            if (this.checkTask()) {
                                return;
                            }
                            int[] tmp1 = (int[])l1.get(j);
                            int[] tmp2 = (int[])l2.get(j);
                            int count = 0;
                            for (int i = 0; i < this.qPaths.size(); ++count, ++i) {
                                int[] result;
                                paths = new ArrayList<int[]>();
                                String p = (String)this.qPaths.elementAt(i);
                                String[] vals = p.split(",");
                                int tsource = tmp2[this.getIndexOf((int[])l1.get(j), Integer.parseInt(vals[0]))];
                                int tdest = tmp2[this.getIndexOf((int[])l1.get(j), Integer.parseInt(vals[1]))];
                                String tmp = vals[2].substring(1);
                                String condition = tmp.substring(0, 1);
                                if (tmp.indexOf(61) != -1) {
                                    condition = tmp.substring(0, tmp.indexOf(61) + 1);
                                }
                                if ((result = this.bfs(this.target, tsource, tdest, condition, Integer.parseInt(tmp.substring(condition.length())), Common.DIRECTED)) == null) break;
                                paths.add(result);
                            }
                            if (count != this.qPaths.size()) continue;
                            l3.add(tmp1);
                            l4.add(tmp2);
                            this.allPaths.add(paths);
                        }
                        this.setArrayDest(l4);
                        this.setArraySource(l3);
                        val.setValue(l4.size());
                    }
                    if (val.intValue() > 500) {
                        int r = this.chooseHowToShow(val.intValue());
                        if (r == 0) {
                            this.taskMonitor.setPercentCompleted(0);
                            this.taskMonitor.setStatus("Draw results...");
                            gpComplexArray = this.convertComplexListToNetworkList(this.array, this.target);
                            this.imageList = new Image[this.array.size()];
                            break block26;
                        }
                        if (r != 1) {
                            this.completedSuccessfully = false;
                            return;
                        }
                        this.imageList = null;
                        break block25;
                    }
                    this.taskMonitor.setPercentCompleted(0);
                    this.taskMonitor.setStatus("Draw results...");
                    GraphPerspective[] gpComplexArray2 = this.convertComplexListToNetworkList(this.array, this.target);
                    this.imageList = new Image[this.array.size()];
                    for (int i = 0; i < this.array.size(); ++i) {
                        if (this.checkTask()) {
                            return;
                        }
                        this.taskMonitor.setPercentCompleted(i * 100 / gpComplexArray2.length);
                        this.imageList[i] = this.convertNetworkToImage(gpComplexArray2[i], Common.imageSize, Common.imageSize);
                    }
                    break block25;
                }
                catch (Exception e) {
                    this.completedSuccessfully = false;
                    this.target.putClientData("NetMatch_running", (Object)Boolean.FALSE);
                    this.taskMonitor.setException((Throwable)e, "Please check data!");
                    return;
                }
                catch (Error e) {
                    this.completedSuccessfully = false;
                    this.target.putClientData("NetMatch_running", (Object)Boolean.FALSE);
                    this.taskMonitor.setException((Throwable)e, "NetMatch cancelled!");
                }
                return;
            }
            for (int i = 0; i < this.array.size(); ++i) {
                if (this.checkTask()) {
                    return;
                }
                this.taskMonitor.setPercentCompleted(i * 100 / gpComplexArray.length);
                this.imageList[i] = this.convertNetworkToImage(gpComplexArray[i], Common.imageSize, Common.imageSize);
            }
        }
        if (this.checkTask()) {
            return;
        }
        this.completedSuccessfully = true;
        System.out.println("Netmatch elapsed time:" + (end - start));
    }

    private int getIndexOf(int[] array, int val) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != val) continue;
            return i;
        }
        return -1;
    }

    private boolean isPruningPossible(String cond) {
        return cond.equals("=") || cond.equals("<") || cond.equals("<=");
    }

    private int[] bfs(CyNetwork tnetwork, int source, int dest, String condition, int number, boolean directed) {
        if (source == dest) {
            return null;
        }
        if (number == 0 && condition.equals("=")) {
            return null;
        }
        BfsPath bfsPath = new BfsPath();
        ArrayList<BfsPath> queue = new ArrayList<BfsPath>();
        queue.add(bfsPath);
        boolean prune = this.isPruningPossible(condition);
        while (!queue.isEmpty()) {
            int nodeId;
            if (this.checkTask()) {
                return null;
            }
            bfsPath = (BfsPath)queue.get(0);
            queue.remove(0);
            if (bfsPath.isEmpty()) {
                nodeId = source;
            } else {
                Pair p = bfsPath.getLastEdge();
                CyEdge edge = (CyEdge)tnetwork.getEdge(p.getEdge());
                nodeId = p.isOutGoingEdge() ? tnetwork.getIndex(edge.getTarget()) : tnetwork.getIndex(edge.getSource());
            }
            if (prune && bfsPath.size() > number) {
                return null;
            }
            if (dest == nodeId && bfsPath.checkCondition(condition, number)) {
                System.out.println("ApproximatePath found: Source:" + tnetwork.getNode(source).getIdentifier() + " Dest:" + tnetwork.getNode(dest).getIdentifier() + " Directed: " + directed);
                return bfsPath.getApproximatePath(tnetwork);
            }
            int[] adjEdgesOut = tnetwork.getAdjacentEdgeIndicesArray(nodeId, false, false, true);
            for (int i = 0; i < adjEdgesOut.length; ++i) {
                if (bfsPath.contains(adjEdgesOut[i])) continue;
                BfsPath newBfsPath = new BfsPath(bfsPath);
                newBfsPath.add(adjEdgesOut[i], true);
                queue.add(newBfsPath);
            }
            if (directed) continue;
            int[] adjEdgesIn = tnetwork.getAdjacentEdgeIndicesArray(nodeId, false, true, false);
            for (int i = 0; i < adjEdgesIn.length; ++i) {
                if (bfsPath.contains(adjEdgesIn[i])) continue;
                BfsPath newBfsPath = new BfsPath(bfsPath);
                newBfsPath.add(adjEdgesIn[i], false);
                queue.add(newBfsPath);
            }
        }
        return null;
    }

    private void printQueue(List queue) {
        System.out.print("[");
        for (int i = 0; i < queue.size(); ++i) {
            System.out.print(((CyNode)queue.get(i)).getIdentifier() + " ");
        }
        System.out.println("]");
    }

    public Image[] getImageList() {
        return this.imageList;
    }

    public ArrayList getArrayDest() {
        return this.array;
    }

    public ArrayList getArraySource() {
        return this.source;
    }

    public void setArrayDest(ArrayList a) {
        this.array = a;
    }

    public void setArraySource(ArrayList a) {
        this.source = a;
    }

    private GraphPerspective convertComplexToNetwork(int[] complex, CyNetwork sourceNetwork) {
        GraphPerspective gpComplex = sourceNetwork.createGraphPerspective(complex);
        return gpComplex;
    }

    private GraphPerspective[] convertComplexListToNetworkList(ArrayList complexList, CyNetwork sourceNetwork) {
        int val = complexList.size();
        GraphPerspective[] gpComplexArray = new GraphPerspective[val];
        for (int i = 0; i < val; ++i) {
            gpComplexArray[i] = this.convertComplexToNetwork((int[])complexList.get(i), sourceNetwork);
        }
        return gpComplexArray;
    }

    private Image convertNetworkToImage(GraphPerspective gpInput, int height, int width) {
        PGraphView view = new PGraphView(gpInput);
        Iterator in = view.getNodeViewsIterator();
        while (in.hasNext()) {
            NodeView nv = (NodeView)in.next();
            String label = nv.getNode().getIdentifier();
            nv.getLabel().setText(label);
            nv.setWidth(40.0);
            nv.setHeight(40.0);
            nv.setShape(2);
            nv.setUnselectedPaint((Paint)Color.red);
            nv.setBorderPaint((Paint)Color.black);
            nv.setXPosition(view.getCanvas().getLayer().getGlobalFullBounds().getWidth() * Math.random());
            nv.setYPosition((view.getCanvas().getLayer().getGlobalFullBounds().getHeight() + 100.0) * Math.random());
        }
        Iterator ie = view.getEdgeViewsIterator();
        while (ie.hasNext()) {
            EdgeView ev = (EdgeView)ie.next();
            ev.setUnselectedPaint((Paint)Color.blue);
            ev.setTargetEdgeEnd(5);
            ev.setTargetEdgeEndPaint((Paint)Color.CYAN);
            ev.setSourceEdgeEndPaint((Paint)Color.CYAN);
            ev.setStroke((Stroke)new BasicStroke(5.0f));
        }
        Image image = view.getCanvas().getLayer().toImage(width, height, null);
        return image;
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void setPercentageComplete(int val) {
        this.taskMonitor.setPercentCompleted(val);
    }

    public boolean checkTask() {
        if (this.interrupted) {
            this.target.putClientData("NetMatch_running", (Object)Boolean.FALSE);
        }
        return this.interrupted;
    }

    private int chooseHowToShow(int matches) {
        Object[] message = new Object[4];
        message[0] = "The number of matches is " + matches + ". Choose one of the following options:";
        ButtonGroup g = new ButtonGroup();
        JRadioButton c1 = new JRadioButton("Show results in text and graphic mode.", false);
        JRadioButton c2 = new JRadioButton("Show results in text mode.", true);
        JRadioButton c3 = new JRadioButton("Don't show results.", false);
        g.add(c1);
        g.add(c2);
        g.add(c3);
        message[1] = c1;
        message[2] = c2;
        message[3] = c3;
        Object[] options = new String[]{"Ok"};
        JOptionPane.showOptionDialog(this.frame, message, "NetMatch", -1, 1, null, options, options[0]);
        if (c1.isSelected()) {
            return 0;
        }
        if (c2.isSelected()) {
            return 1;
        }
        return 2;
    }
}

